/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformDiscreteSampler;

abstract class AbstractDiscreteDistribution
implements DiscreteDistribution {
    AbstractDiscreteDistribution() {
    }

    @Override
    public double probability(int n, int n2) {
        if (n2 < n) {
            throw new DistributionException("{0} < {1}", n2, n);
        }
        return this.cumulativeProbability(n2) - this.cumulativeProbability(n);
    }

    @Override
    public int inverseCumulativeProbability(double d) {
        boolean bl;
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        int n = this.getSupportLowerBound();
        if (d == 0.0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(n) >= d) {
                return n;
            }
        } else {
            --n;
        }
        int n2 = this.getSupportUpperBound();
        if (d == 1.0) {
            return n2;
        }
        double d2 = this.getMean();
        double d3 = Math.sqrt(this.getVariance());
        boolean bl2 = bl = !Double.isInfinite(d2) && !Double.isNaN(d2) && !Double.isInfinite(d3) && !Double.isNaN(d3) && d3 != 0.0;
        if (bl) {
            double d4 = Math.sqrt((1.0 - d) / d);
            double d5 = d2 - d4 * d3;
            if (d5 > (double)n) {
                n = (int)Math.ceil(d5) - 1;
            }
            if ((d5 = d2 + (d4 = 1.0 / d4) * d3) < (double)n2) {
                n2 = (int)Math.ceil(d5) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(d, n, n2);
    }

    private int solveInverseCumulativeProbability(double d, int n, int n2) {
        while (n + 1 < n2) {
            double d2;
            int n3 = (n + n2) / 2;
            if (n3 < n || n3 > n2) {
                n3 = n + (n2 - n) / 2;
            }
            if ((d2 = this.checkedCumulativeProbability(n3)) >= d) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    private double checkedCumulativeProbability(int n) {
        double d = this.cumulativeProbability(n);
        if (Double.isNaN(d)) {
            throw new IllegalStateException("Internal error");
        }
        return d;
    }

    public static int[] sample(int n, DiscreteDistribution.Sampler sampler) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = sampler.sample();
        }
        return nArray;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new InverseTransformDiscreteSampler(uniformRandomProvider, AbstractDiscreteDistribution.this.createICPF());
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }

    private DiscreteInverseCumulativeProbabilityFunction createICPF() {
        return new DiscreteInverseCumulativeProbabilityFunction(){

            @Override
            public int inverseCumulativeProbability(double d) {
                return AbstractDiscreteDistribution.this.inverseCumulativeProbability(d);
            }
        };
    }
}

