/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.LogGamma;
import org.apache.commons.numbers.gamma.RegularizedBeta;

public class TDistribution
extends AbstractContinuousDistribution {
    private final double degreesOfFreedom;
    private final double dofOver2;
    private final double factor;
    private final double mean;
    private final double variance;

    public TDistribution(double d) {
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        this.degreesOfFreedom = d;
        this.dofOver2 = 0.5 * d;
        this.factor = LogGamma.value(this.dofOver2 + 0.5) - 0.5 * (Math.log(Math.PI) + Math.log(d)) - LogGamma.value(this.dofOver2);
        double d2 = this.mean = d > 1.0 ? 0.0 : Double.NaN;
        this.variance = d > 2.0 ? d / (d - 2.0) : (d > 1.0 && d <= 2.0 ? Double.POSITIVE_INFINITY : Double.NaN);
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double density(double d) {
        return Math.exp(this.logDensity(d));
    }

    @Override
    public double logDensity(double d) {
        double d2 = this.dofOver2 + 0.5;
        return this.factor - d2 * Math.log1p(d * d / this.degreesOfFreedom);
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d == 0.0) {
            return 0.5;
        }
        double d2 = RegularizedBeta.value(this.degreesOfFreedom / (this.degreesOfFreedom + d * d), this.dofOver2, 0.5);
        return d < 0.0 ? 0.5 * d2 : 1.0 - 0.5 * d2;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

