/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.regression;

import io.virtdata.shaded.oac.statistics.distribution.TDistribution;
import io.virtdata.shaded.oac.statistics.regression.ModelSpecificationException;
import io.virtdata.shaded.oac.statistics.regression.RegressionResults;
import io.virtdata.shaded.oac.statistics.regression.UpdatingMultipleLinearRegression;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.core.Precision;

public class SimpleRegression
implements Serializable,
UpdatingMultipleLinearRegression {
    private static final long serialVersionUID = -3004689053607543335L;
    private double sumX = 0.0;
    private double sumXX = 0.0;
    private double sumY = 0.0;
    private double sumYY = 0.0;
    private double sumXY = 0.0;
    private long n = 0L;
    private double xbar = 0.0;
    private double ybar = 0.0;
    private final boolean hasIntercept;

    public SimpleRegression() {
        this(true);
    }

    public SimpleRegression(boolean bl) {
        this.hasIntercept = bl;
    }

    public void addData(double d, double d2) {
        if (this.n == 0L) {
            this.xbar = d;
            this.ybar = d2;
        } else if (this.hasIntercept) {
            double d3 = 1.0 + (double)this.n;
            double d4 = (double)this.n / (1.0 + (double)this.n);
            double d5 = d - this.xbar;
            double d6 = d2 - this.ybar;
            this.sumXX += d5 * d5 * d4;
            this.sumYY += d6 * d6 * d4;
            this.sumXY += d5 * d6 * d4;
            this.xbar += d5 / d3;
            this.ybar += d6 / d3;
        }
        if (!this.hasIntercept) {
            this.sumXX += d * d;
            this.sumYY += d2 * d2;
            this.sumXY += d * d2;
        }
        this.sumX += d;
        this.sumY += d2;
        ++this.n;
    }

    public void append(SimpleRegression simpleRegression) {
        if (this.n == 0L) {
            this.xbar = simpleRegression.xbar;
            this.ybar = simpleRegression.ybar;
            this.sumXX = simpleRegression.sumXX;
            this.sumYY = simpleRegression.sumYY;
            this.sumXY = simpleRegression.sumXY;
        } else if (this.hasIntercept) {
            double d = (double)simpleRegression.n / (double)(simpleRegression.n + this.n);
            double d2 = (double)(this.n * simpleRegression.n) / (double)(simpleRegression.n + this.n);
            double d3 = simpleRegression.xbar - this.xbar;
            double d4 = simpleRegression.ybar - this.ybar;
            this.sumXX += simpleRegression.sumXX + d3 * d3 * d2;
            this.sumYY += simpleRegression.sumYY + d4 * d4 * d2;
            this.sumXY += simpleRegression.sumXY + d3 * d4 * d2;
            this.xbar += d3 * d;
            this.ybar += d4 * d;
        } else {
            this.sumXX += simpleRegression.sumXX;
            this.sumYY += simpleRegression.sumYY;
            this.sumXY += simpleRegression.sumXY;
        }
        this.sumX += simpleRegression.sumX;
        this.sumY += simpleRegression.sumY;
        this.n += simpleRegression.n;
    }

    public void removeData(double d, double d2) {
        if (this.n > 0L) {
            if (this.hasIntercept) {
                double d3 = (double)this.n - 1.0;
                double d4 = (double)this.n / ((double)this.n - 1.0);
                double d5 = d - this.xbar;
                double d6 = d2 - this.ybar;
                this.sumXX -= d5 * d5 * d4;
                this.sumYY -= d6 * d6 * d4;
                this.sumXY -= d5 * d6 * d4;
                this.xbar -= d5 / d3;
                this.ybar -= d6 / d3;
            } else {
                double d7 = (double)this.n - 1.0;
                this.sumXX -= d * d;
                this.sumYY -= d2 * d2;
                this.sumXY -= d * d2;
                this.xbar -= d / d7;
                this.ybar -= d2 / d7;
            }
            this.sumX -= d;
            this.sumY -= d2;
            --this.n;
        }
    }

    public void addData(double[][] dArray) throws ModelSpecificationException {
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i].length < 2) {
                throw new ModelSpecificationException(LocalizedFormats.INVALID_REGRESSION_OBSERVATION, dArray[i].length, 2);
            }
            this.addData(dArray[i][0], dArray[i][1]);
        }
    }

    @Override
    public void addObservation(double[] dArray, double d) throws ModelSpecificationException {
        if (dArray == null || dArray.length == 0) {
            throw new ModelSpecificationException(LocalizedFormats.INVALID_REGRESSION_OBSERVATION, dArray != null ? dArray.length : 0, 1);
        }
        this.addData(dArray[0], d);
    }

    @Override
    public void addObservations(double[][] dArray, double[] dArray2) throws ModelSpecificationException {
        int n;
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            throw new ModelSpecificationException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, dArray == null ? 0 : dArray.length, dArray2 == null ? 0 : dArray2.length);
        }
        boolean bl = true;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] != null && dArray[n].length != 0) continue;
            bl = false;
        }
        if (!bl) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, 0, 1);
        }
        for (n = 0; n < dArray.length; ++n) {
            this.addData(dArray[n][0], dArray2[n]);
        }
    }

    public void removeData(double[][] dArray) {
        for (int i = 0; i < dArray.length && this.n > 0L; ++i) {
            this.removeData(dArray[i][0], dArray[i][1]);
        }
    }

    @Override
    public void clear() {
        this.sumX = 0.0;
        this.sumXX = 0.0;
        this.sumY = 0.0;
        this.sumYY = 0.0;
        this.sumXY = 0.0;
        this.n = 0L;
    }

    @Override
    public long getN() {
        return this.n;
    }

    public double predict(double d) {
        double d2 = this.getSlope();
        if (this.hasIntercept) {
            return this.getIntercept(d2) + d2 * d;
        }
        return d2 * d;
    }

    public double getIntercept() {
        return this.hasIntercept ? this.getIntercept(this.getSlope()) : 0.0;
    }

    @Override
    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    public double getSlope() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        if (FastMath.abs(this.sumXX) < 4.9E-323) {
            return Double.NaN;
        }
        return this.sumXY / this.sumXX;
    }

    public double getSumSquaredErrors() {
        return FastMath.max(0.0, this.sumYY - this.sumXY * this.sumXY / this.sumXX);
    }

    public double getTotalSumSquares() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.sumYY;
    }

    public double getXSumSquares() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.sumXX;
    }

    public double getSumOfCrossProducts() {
        return this.sumXY;
    }

    public double getRegressionSumSquares() {
        return this.getRegressionSumSquares(this.getSlope());
    }

    public double getMeanSquareError() {
        if (this.n < 3L) {
            return Double.NaN;
        }
        return this.hasIntercept ? this.getSumSquaredErrors() / (double)(this.n - 2L) : this.getSumSquaredErrors() / (double)(this.n - 1L);
    }

    public double getR() {
        double d = this.getSlope();
        double d2 = FastMath.sqrt(this.getRSquare());
        if (d < 0.0) {
            d2 = -d2;
        }
        return d2;
    }

    public double getRSquare() {
        double d = this.getTotalSumSquares();
        return (d - this.getSumSquaredErrors()) / d;
    }

    public double getInterceptStdErr() {
        if (!this.hasIntercept) {
            return Double.NaN;
        }
        return FastMath.sqrt(this.getMeanSquareError() * (1.0 / (double)this.n + this.xbar * this.xbar / this.sumXX));
    }

    public double getSlopeStdErr() {
        return FastMath.sqrt(this.getMeanSquareError() / this.sumXX);
    }

    public double getSlopeConfidenceInterval() throws OutOfRangeException {
        return this.getSlopeConfidenceInterval(0.05);
    }

    public double getSlopeConfidenceInterval(double d) throws OutOfRangeException {
        if (this.n < 3L) {
            return Double.NaN;
        }
        if (d >= 1.0 || d <= 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.SIGNIFICANCE_LEVEL, (Number)d, 0, 1);
        }
        TDistribution tDistribution = new TDistribution(this.n - 2L);
        return this.getSlopeStdErr() * tDistribution.inverseCumulativeProbability(1.0 - d / 2.0);
    }

    public double getSignificance() {
        if (this.n < 3L) {
            return Double.NaN;
        }
        TDistribution tDistribution = new TDistribution(this.n - 2L);
        return 2.0 * (1.0 - tDistribution.cumulativeProbability(FastMath.abs(this.getSlope()) / this.getSlopeStdErr()));
    }

    private double getIntercept(double d) {
        if (this.hasIntercept) {
            return (this.sumY - d * this.sumX) / (double)this.n;
        }
        return 0.0;
    }

    private double getRegressionSumSquares(double d) {
        return d * d * this.sumXX;
    }

    @Override
    public RegressionResults regress() throws ModelSpecificationException, NoDataException {
        if (this.hasIntercept) {
            if (this.n < 3L) {
                throw new NoDataException(LocalizedFormats.NOT_ENOUGH_DATA_REGRESSION);
            }
            if (FastMath.abs(this.sumXX) > Precision.SAFE_MIN) {
                double[] dArray = new double[]{this.getIntercept(), this.getSlope()};
                double d = this.getMeanSquareError();
                double d2 = this.sumYY + this.sumY * this.sumY / (double)this.n;
                double[] dArray2 = new double[]{d * (this.xbar * this.xbar / this.sumXX + 1.0 / (double)this.n), -this.xbar * d / this.sumXX, d / this.sumXX};
                return new RegressionResults(dArray, new double[][]{dArray2}, true, this.n, 2, this.sumY, d2, this.getSumSquaredErrors(), true, false);
            }
            double[] dArray = new double[]{this.sumY / (double)this.n, Double.NaN};
            double[] dArray3 = new double[]{this.ybar / ((double)this.n - 1.0), Double.NaN, Double.NaN};
            return new RegressionResults(dArray, new double[][]{dArray3}, true, this.n, 1, this.sumY, this.sumYY, this.getSumSquaredErrors(), true, false);
        }
        if (this.n < 2L) {
            throw new NoDataException(LocalizedFormats.NOT_ENOUGH_DATA_REGRESSION);
        }
        if (!Double.isNaN(this.sumXX)) {
            double[] dArray = new double[]{this.getMeanSquareError() / this.sumXX};
            double[] dArray4 = new double[]{this.sumXY / this.sumXX};
            return new RegressionResults(dArray4, new double[][]{dArray}, true, this.n, 1, this.sumY, this.sumYY, this.getSumSquaredErrors(), false, false);
        }
        double[] dArray = new double[]{Double.NaN};
        double[] dArray5 = new double[]{Double.NaN};
        return new RegressionResults(dArray5, new double[][]{dArray}, true, this.n, 1, Double.NaN, Double.NaN, Double.NaN, false, false);
    }

    @Override
    public RegressionResults regress(int[] nArray) throws MathIllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ARRAY_ZERO_LENGTH_OR_NULL_NOT_ALLOWED, new Object[0]);
        }
        if (nArray.length > 2 || nArray.length > 1 && !this.hasIntercept) {
            throw new ModelSpecificationException(LocalizedFormats.ARRAY_SIZE_EXCEEDS_MAX_VARIABLES, nArray.length > 1 && !this.hasIntercept ? 1 : 2);
        }
        if (this.hasIntercept) {
            if (nArray.length == 2) {
                if (nArray[0] == 1) {
                    throw new ModelSpecificationException(LocalizedFormats.NOT_INCREASING_SEQUENCE, new Object[0]);
                }
                if (nArray[0] != 0) {
                    throw new OutOfRangeException(nArray[0], (Number)0, 1);
                }
                if (nArray[1] != 1) {
                    throw new OutOfRangeException(nArray[0], (Number)0, 1);
                }
                return this.regress();
            }
            if (nArray[0] != 1 && nArray[0] != 0) {
                throw new OutOfRangeException(nArray[0], (Number)0, 1);
            }
            double d = this.sumY * this.sumY / (double)this.n;
            double d2 = this.sumYY + d;
            if (nArray[0] == 0) {
                double[] dArray = new double[]{this.sumYY / (double)((this.n - 1L) * this.n)};
                double[] dArray2 = new double[]{this.ybar};
                return new RegressionResults(dArray2, new double[][]{dArray}, true, this.n, 1, this.sumY, d2 + d, this.sumYY, true, false);
            }
            if (nArray[0] == 1) {
                double d3 = this.sumXX + this.sumX * this.sumX / (double)this.n;
                double d4 = this.sumXY + this.sumX * this.sumY / (double)this.n;
                double d5 = FastMath.max(0.0, d2 - d4 * d4 / d3);
                double d6 = d5 / (double)(this.n - 1L);
                if (!Double.isNaN(d3)) {
                    double[] dArray = new double[]{d6 / d3};
                    double[] dArray3 = new double[]{d4 / d3};
                    return new RegressionResults(dArray3, new double[][]{dArray}, true, this.n, 1, this.sumY, d2, d5, false, false);
                }
                double[] dArray = new double[]{Double.NaN};
                double[] dArray4 = new double[]{Double.NaN};
                return new RegressionResults(dArray4, new double[][]{dArray}, true, this.n, 1, Double.NaN, Double.NaN, Double.NaN, false, false);
            }
        } else {
            if (nArray[0] != 0) {
                throw new OutOfRangeException(nArray[0], (Number)0, 0);
            }
            return this.regress();
        }
        return null;
    }
}

