/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.function;

import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.util.FastMath;

public class Sinc
implements UnivariateDifferentiableFunction {
    private static final double SHORTCUT = 0.006;
    private final boolean normalized;

    public Sinc() {
        this(false);
    }

    public Sinc(boolean bl) {
        this.normalized = bl;
    }

    @Override
    public double value(double d) {
        double d2;
        double d3 = d2 = this.normalized ? Math.PI * d : d;
        if (FastMath.abs(d2) <= 0.006) {
            double d4 = d2 * d2;
            return ((d4 - 20.0) * d4 + 120.0) / 120.0;
        }
        return FastMath.sin(d2) / d2;
    }

    @Override
    public DerivativeStructure value(DerivativeStructure derivativeStructure) throws DimensionMismatchException {
        double d = (this.normalized ? Math.PI : 1.0) * derivativeStructure.getValue();
        double d2 = d * d;
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        if (FastMath.abs(d) <= 0.006) {
            for (int i = 0; i < dArray.length; ++i) {
                int n = i / 2;
                dArray[i] = (i & 1) == 0 ? (double)((n & 1) == 0 ? 1 : -1) * (1.0 / (double)(i + 1) - d2 * (1.0 / (double)(2 * i + 6) - d2 / (double)(24 * i + 120))) : ((n & 1) == 0 ? -d : d) * (1.0 / (double)(i + 2) - d2 * (1.0 / (double)(6 * i + 24) - d2 / (double)(120 * i + 720)));
            }
        } else {
            double d3 = 1.0 / d;
            double d4 = FastMath.cos(d);
            double d5 = FastMath.sin(d);
            dArray[0] = d3 * d5;
            double[] dArray2 = new double[dArray.length];
            dArray2[0] = 1.0;
            double d6 = d3;
            for (int i = 1; i < dArray.length; ++i) {
                int n;
                double d7 = 0.0;
                double d8 = 0.0;
                if ((i & 1) == 0) {
                    dArray2[i] = 0.0;
                    n = i;
                } else {
                    dArray2[i] = dArray2[i - 1];
                    d8 = dArray2[i];
                    n = i - 1;
                }
                for (int j = n; j > 1; j -= 2) {
                    dArray2[j] = (double)(j - i) * dArray2[j] - dArray2[j - 1];
                    d7 = d7 * d2 + dArray2[j];
                    dArray2[j - 1] = (double)(j - 1 - i) * dArray2[j - 1] + dArray2[j - 2];
                    d8 = d8 * d2 + dArray2[j - 1];
                }
                dArray2[0] = dArray2[0] * (double)(-i);
                d7 = d7 * d2 + dArray2[0];
                dArray[i] = (d6 *= d3) * (d7 * d5 + d8 * d * d4);
            }
        }
        if (this.normalized) {
            double d9 = Math.PI;
            int n = 1;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] * d9;
                d9 *= Math.PI;
            }
        }
        return derivativeStructure.compose(dArray);
    }
}

