/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.Field;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.linear.Array2DRowFieldMatrix;
import org.apache.commons.math4.linear.ArrayFieldVector;
import org.apache.commons.math4.linear.FieldDecompositionSolver;
import org.apache.commons.math4.linear.FieldMatrix;
import org.apache.commons.math4.linear.FieldVector;
import org.apache.commons.math4.linear.NonSquareMatrixException;
import org.apache.commons.math4.linear.SingularMatrixException;
import org.apache.commons.math4.util.MathArrays;

public class FieldLUDecomposition<T extends FieldElement<T>> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecomposition(FieldMatrix<T> fieldMatrix) {
        int n;
        if (!fieldMatrix.isSquare()) {
            throw new NonSquareMatrixException(fieldMatrix.getRowDimension(), fieldMatrix.getColumnDimension());
        }
        int n2 = fieldMatrix.getColumnDimension();
        this.field = fieldMatrix.getField();
        this.lu = fieldMatrix.getData();
        this.pivot = new int[n2];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (n = 0; n < n2; ++n) {
            this.pivot[n] = n;
        }
        this.even = true;
        this.singular = false;
        for (n = 0; n < n2; ++n) {
            int n3;
            Object object;
            int n4;
            FieldElement<FieldElement> fieldElement = (FieldElement)this.field.getZero();
            for (n4 = 0; n4 < n; ++n4) {
                object = this.lu[n4];
                fieldElement = object[n];
                for (n3 = 0; n3 < n4; ++n3) {
                    fieldElement = fieldElement.subtract((FieldElement)object[n3].multiply(this.lu[n3][n]));
                }
                object[n] = fieldElement;
            }
            n4 = n;
            for (int i = n; i < n2; ++i) {
                T[] TArray = this.lu[i];
                fieldElement = TArray[n];
                for (int j = 0; j < n; ++j) {
                    fieldElement = fieldElement.subtract((FieldElement)TArray[j].multiply(this.lu[j][n]));
                }
                TArray[n] = fieldElement;
                if (!this.lu[n4][n].equals(this.field.getZero())) continue;
                ++n4;
            }
            if (n4 >= n2) {
                this.singular = true;
                return;
            }
            if (n4 != n) {
                int n5;
                FieldElement fieldElement2 = (FieldElement)this.field.getZero();
                for (n5 = 0; n5 < n2; ++n5) {
                    fieldElement2 = this.lu[n4][n5];
                    this.lu[n4][n5] = this.lu[n][n5];
                    this.lu[n][n5] = fieldElement2;
                }
                n5 = this.pivot[n4];
                this.pivot[n4] = this.pivot[n];
                this.pivot[n] = n5;
                this.even = !this.even;
            }
            object = this.lu[n][n];
            for (n3 = n + 1; n3 < n2; ++n3) {
                T[] TArray = this.lu[n3];
                TArray[n] = (FieldElement)TArray[n].divide(object);
            }
        }
    }

    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int n = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, n, n);
            for (int i = 0; i < n; ++i) {
                T[] TArray = this.lu[i];
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setEntry(i, j, TArray[j]);
                }
                this.cachedL.setEntry(i, i, (FieldElement)this.field.getOne());
            }
        }
        return this.cachedL;
    }

    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int n = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, n, n);
            for (int i = 0; i < n; ++i) {
                T[] TArray = this.lu[i];
                for (int j = i; j < n; ++j) {
                    this.cachedU.setEntry(i, j, TArray[j]);
                }
            }
        }
        return this.cachedU;
    }

    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int n = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, n, n);
            for (int i = 0; i < n; ++i) {
                this.cachedP.setEntry(i, this.pivot[i], (FieldElement)this.field.getOne());
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int n = this.pivot.length;
        FieldElement fieldElement = this.even ? (FieldElement)this.field.getOne() : ((FieldElement)this.field.getZero()).subtract((FieldElement)this.field.getOne());
        for (int i = 0; i < n; ++i) {
            fieldElement = (FieldElement)fieldElement.multiply(this.lu[i][i]);
        }
        return (T)fieldElement;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new Solver(this.field, this.lu, this.pivot, this.singular);
    }

    private static class Solver<T extends FieldElement<T>>
    implements FieldDecompositionSolver<T> {
        private final Field<T> field;
        private final T[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(Field<T> field, T[][] TArray, int[] nArray, boolean bl) {
            this.field = field;
            this.lu = TArray;
            this.pivot = nArray;
            this.singular = bl;
        }

        @Override
        public boolean isNonSingular() {
            return !this.singular;
        }

        @Override
        public FieldVector<T> solve(FieldVector<T> fieldVector) {
            try {
                return this.solve((ArrayFieldVector)fieldVector);
            }
            catch (ClassCastException classCastException) {
                int n;
                FieldElement fieldElement;
                int n2;
                int n3 = this.pivot.length;
                if (fieldVector.getDimension() != n3) {
                    throw new DimensionMismatchException(fieldVector.getDimension(), n3);
                }
                if (this.singular) {
                    throw new SingularMatrixException();
                }
                FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    fieldElementArray[n2] = fieldVector.getEntry(this.pivot[n2]);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    fieldElement = fieldElementArray[n2];
                    for (n = n2 + 1; n < n3; ++n) {
                        fieldElementArray[n] = fieldElementArray[n].subtract((FieldElement)fieldElement.multiply(this.lu[n][n2]));
                    }
                }
                for (n2 = n3 - 1; n2 >= 0; --n2) {
                    fieldElementArray[n2] = (FieldElement)fieldElementArray[n2].divide(this.lu[n2][n2]);
                    fieldElement = fieldElementArray[n2];
                    for (n = 0; n < n2; ++n) {
                        fieldElementArray[n] = fieldElementArray[n].subtract((FieldElement)fieldElement.multiply(this.lu[n][n2]));
                    }
                }
                return new ArrayFieldVector(this.field, fieldElementArray, false);
            }
        }

        @Override
        public ArrayFieldVector<T> solve(ArrayFieldVector<T> arrayFieldVector) {
            int n;
            FieldElement fieldElement;
            int n2;
            int n3 = this.pivot.length;
            int n4 = arrayFieldVector.getDimension();
            if (n4 != n3) {
                throw new DimensionMismatchException(n4, n3);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, n3);
            for (n2 = 0; n2 < n3; ++n2) {
                fieldElementArray[n2] = arrayFieldVector.getEntry(this.pivot[n2]);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                fieldElement = fieldElementArray[n2];
                for (n = n2 + 1; n < n3; ++n) {
                    fieldElementArray[n] = fieldElementArray[n].subtract((FieldElement)fieldElement.multiply(this.lu[n][n2]));
                }
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                fieldElementArray[n2] = (FieldElement)fieldElementArray[n2].divide(this.lu[n2][n2]);
                fieldElement = fieldElementArray[n2];
                for (n = 0; n < n2; ++n) {
                    fieldElementArray[n] = fieldElementArray[n].subtract((FieldElement)fieldElement.multiply(this.lu[n][n2]));
                }
            }
            return new ArrayFieldVector(fieldElementArray, false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> fieldMatrix) {
            Object object;
            int n;
            FieldElement[] fieldElementArray;
            int n2;
            int n3 = this.pivot.length;
            if (fieldMatrix.getRowDimension() != n3) {
                throw new DimensionMismatchException(fieldMatrix.getRowDimension(), n3);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int n4 = fieldMatrix.getColumnDimension();
            FieldElement[][] fieldElementArray2 = (FieldElement[][])MathArrays.buildArray(this.field, n3, n4);
            for (n2 = 0; n2 < n3; ++n2) {
                fieldElementArray = fieldElementArray2[n2];
                n = this.pivot[n2];
                for (int i = 0; i < n4; ++i) {
                    fieldElementArray[i] = fieldMatrix.getEntry(n, i);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                fieldElementArray = fieldElementArray2[n2];
                for (n = n2 + 1; n < n3; ++n) {
                    FieldElement[] fieldElementArray3 = fieldElementArray2[n];
                    object = this.lu[n][n2];
                    for (int i = 0; i < n4; ++i) {
                        fieldElementArray3[i] = fieldElementArray3[i].subtract((FieldElement)fieldElementArray[i].multiply(object));
                    }
                }
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                int n5;
                fieldElementArray = fieldElementArray2[n2];
                T t = this.lu[n2][n2];
                for (n5 = 0; n5 < n4; ++n5) {
                    fieldElementArray[n5] = (FieldElement)fieldElementArray[n5].divide(t);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    object = fieldElementArray2[n5];
                    T t2 = this.lu[n5][n2];
                    for (int i = 0; i < n4; ++i) {
                        object[i] = object[i].subtract((FieldElement)((FieldElement)fieldElementArray[i].multiply(t2)));
                    }
                }
            }
            return new Array2DRowFieldMatrix(this.field, fieldElementArray2, false);
        }

        @Override
        public FieldMatrix<T> getInverse() {
            int n = this.pivot.length;
            FieldElement fieldElement = (FieldElement)this.field.getOne();
            Array2DRowFieldMatrix<FieldElement> array2DRowFieldMatrix = new Array2DRowFieldMatrix<FieldElement>(this.field, n, n);
            for (int i = 0; i < n; ++i) {
                array2DRowFieldMatrix.setEntry(i, i, fieldElement);
            }
            return this.solve(array2DRowFieldMatrix);
        }
    }
}

