/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.ExceptionContext;
import org.apache.commons.math4.exception.util.LocalizedFormats;

public class NonPositiveDefiniteMatrixException
extends NumberIsTooSmallException {
    private static final long serialVersionUID = 1641613838113738061L;
    private final int index;
    private final double threshold;

    public NonPositiveDefiniteMatrixException(double d, int n, double d2) {
        super(d, (Number)d2, false);
        this.index = n;
        this.threshold = d2;
        ExceptionContext exceptionContext = this.getContext();
        exceptionContext.addMessage(LocalizedFormats.NOT_POSITIVE_DEFINITE_MATRIX, new Object[0]);
        exceptionContext.addMessage(LocalizedFormats.ARRAY_ELEMENT, d, n);
    }

    public int getRow() {
        return this.index;
    }

    public int getColumn() {
        return this.index;
    }

    public double getThreshold() {
        return this.threshold;
    }
}

