/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.math4.analysis.FunctionUtils;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.function.Add;
import org.apache.commons.math4.analysis.function.Divide;
import org.apache.commons.math4.analysis.function.Multiply;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.MathUnsupportedOperationException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.AbstractRealMatrix;
import org.apache.commons.math4.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.linear.OpenMapRealMatrix;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVectorChangingVisitor;
import org.apache.commons.math4.linear.RealVectorPreservingVisitor;
import org.apache.commons.math4.linear.SparseRealVector;
import org.apache.commons.math4.util.FastMath;

public abstract class RealVector {
    public abstract int getDimension();

    public abstract double getEntry(int var1) throws OutOfRangeException;

    public abstract void setEntry(int var1, double var2) throws OutOfRangeException;

    public void addToEntry(int n, double d) throws OutOfRangeException {
        this.setEntry(n, this.getEntry(n) + d);
    }

    public abstract RealVector append(RealVector var1);

    public abstract RealVector append(double var1);

    public abstract RealVector getSubVector(int var1, int var2) throws NotPositiveException, OutOfRangeException;

    public abstract void setSubVector(int var1, RealVector var2) throws OutOfRangeException;

    public abstract boolean isNaN();

    public abstract boolean isInfinite();

    protected void checkVectorDimensions(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector.getDimension());
    }

    protected void checkVectorDimensions(int n) throws DimensionMismatchException {
        int n2 = this.getDimension();
        if (n2 != n) {
            throw new DimensionMismatchException(n2, n);
        }
    }

    protected void checkIndex(int n) throws OutOfRangeException {
        if (n < 0 || n >= this.getDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, this.getDimension() - 1);
        }
    }

    protected void checkIndices(int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        int n3 = this.getDimension();
        if (n < 0 || n >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, n3 - 1);
        }
        if (n2 < 0 || n2 >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n2, 0, n3 - 1);
        }
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, false);
        }
    }

    public RealVector add(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector);
        RealVector realVector2 = realVector.copy();
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            int n = entry.getIndex();
            realVector2.setEntry(n, entry.getValue() + realVector2.getEntry(n));
        }
        return realVector2;
    }

    public RealVector subtract(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector);
        RealVector realVector2 = realVector.mapMultiply(-1.0);
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            int n = entry.getIndex();
            realVector2.setEntry(n, entry.getValue() + realVector2.getEntry(n));
        }
        return realVector2;
    }

    public RealVector mapAdd(double d) {
        return this.copy().mapAddToSelf(d);
    }

    public RealVector mapAddToSelf(double d) {
        if (d != 0.0) {
            return this.mapToSelf(FunctionUtils.fix2ndArgument(new Add(), d));
        }
        return this;
    }

    public abstract RealVector copy();

    public double dotProduct(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector);
        double d = 0.0;
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            d += this.getEntry(i) * realVector.getEntry(i);
        }
        return d;
    }

    public double cosine(RealVector realVector) throws DimensionMismatchException, MathArithmeticException {
        double d = this.getNorm();
        double d2 = realVector.getNorm();
        if (d == 0.0 || d2 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.dotProduct(realVector) / (d * d2);
    }

    public abstract RealVector ebeDivide(RealVector var1) throws DimensionMismatchException;

    public abstract RealVector ebeMultiply(RealVector var1) throws DimensionMismatchException;

    public double getDistance(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector);
        double d = 0.0;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            double d2 = entry.getValue() - realVector.getEntry(entry.getIndex());
            d += d2 * d2;
        }
        return FastMath.sqrt(d);
    }

    public double getNorm() {
        double d = 0.0;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            double d2 = entry.getValue();
            d += d2 * d2;
        }
        return FastMath.sqrt(d);
    }

    public double getL1Norm() {
        double d = 0.0;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            d += FastMath.abs(entry.getValue());
        }
        return d;
    }

    public double getLInfNorm() {
        double d = 0.0;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            d = FastMath.max(d, FastMath.abs(entry.getValue()));
        }
        return d;
    }

    public double getL1Distance(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector);
        double d = 0.0;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            d += FastMath.abs(entry.getValue() - realVector.getEntry(entry.getIndex()));
        }
        return d;
    }

    public double getLInfDistance(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector);
        double d = 0.0;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            d = FastMath.max(FastMath.abs(entry.getValue() - realVector.getEntry(entry.getIndex())), d);
        }
        return d;
    }

    public int getMinIndex() {
        int n = -1;
        double d = Double.POSITIVE_INFINITY;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!(entry.getValue() <= d)) continue;
            n = entry.getIndex();
            d = entry.getValue();
        }
        return n;
    }

    public double getMinValue() {
        int n = this.getMinIndex();
        return n < 0 ? Double.NaN : this.getEntry(n);
    }

    public int getMaxIndex() {
        int n = -1;
        double d = Double.NEGATIVE_INFINITY;
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!(entry.getValue() >= d)) continue;
            n = entry.getIndex();
            d = entry.getValue();
        }
        return n;
    }

    public double getMaxValue() {
        int n = this.getMaxIndex();
        return n < 0 ? Double.NaN : this.getEntry(n);
    }

    public RealVector mapMultiply(double d) {
        return this.copy().mapMultiplyToSelf(d);
    }

    public RealVector mapMultiplyToSelf(double d) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Multiply(), d));
    }

    public RealVector mapSubtract(double d) {
        return this.copy().mapSubtractToSelf(d);
    }

    public RealVector mapSubtractToSelf(double d) {
        return this.mapAddToSelf(-d);
    }

    public RealVector mapDivide(double d) {
        return this.copy().mapDivideToSelf(d);
    }

    public RealVector mapDivideToSelf(double d) {
        return this.mapToSelf(FunctionUtils.fix2ndArgument(new Divide(), d));
    }

    public RealMatrix outerProduct(RealVector realVector) {
        int n = this.getDimension();
        int n2 = realVector.getDimension();
        AbstractRealMatrix abstractRealMatrix = realVector instanceof SparseRealVector || this instanceof SparseRealVector ? new OpenMapRealMatrix(n, n2) : new Array2DRowRealMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                abstractRealMatrix.setEntry(i, j, this.getEntry(i) * realVector.getEntry(j));
            }
        }
        return abstractRealMatrix;
    }

    public RealVector projection(RealVector realVector) throws DimensionMismatchException, MathArithmeticException {
        double d = realVector.dotProduct(realVector);
        if (d == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return realVector.mapMultiply(this.dotProduct(realVector) / realVector.dotProduct(realVector));
    }

    public void set(double d) {
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            entry.setValue(d);
        }
    }

    public double[] toArray() {
        int n = this.getDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getEntry(i);
        }
        return dArray;
    }

    public RealVector unitVector() throws MathArithmeticException {
        double d = this.getNorm();
        if (d == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        return this.mapDivide(d);
    }

    public void unitize() throws MathArithmeticException {
        double d = this.getNorm();
        if (d == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_NORM, new Object[0]);
        }
        this.mapDivideToSelf(this.getNorm());
    }

    public Iterator<Entry> sparseIterator() {
        return new SparseEntryIterator();
    }

    public Iterator<Entry> iterator() {
        final int n = this.getDimension();
        return new Iterator<Entry>(){
            private int i = 0;
            private Entry e = new Entry();

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            public Entry next() {
                if (this.i < n) {
                    this.e.setIndex(this.i++);
                    return this.e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }
        };
    }

    public RealVector map(UnivariateFunction univariateFunction) {
        return this.copy().mapToSelf(univariateFunction);
    }

    public RealVector mapToSelf(UnivariateFunction univariateFunction) {
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            entry.setValue(univariateFunction.value(entry.getValue()));
        }
        return this;
    }

    public RealVector combine(double d, double d2, RealVector realVector) throws DimensionMismatchException {
        return this.copy().combineToSelf(d, d2, realVector);
    }

    public RealVector combineToSelf(double d, double d2, RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector);
        for (int i = 0; i < this.getDimension(); ++i) {
            double d3 = this.getEntry(i);
            double d4 = realVector.getEntry(i);
            this.setEntry(i, d * d3 + d2 * d4);
        }
        return this;
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        int n = this.getDimension();
        realVectorPreservingVisitor.start(n, 0, n - 1);
        for (int i = 0; i < n; ++i) {
            realVectorPreservingVisitor.visit(i, this.getEntry(i));
        }
        return realVectorPreservingVisitor.end();
    }

    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(n, n2);
        realVectorPreservingVisitor.start(this.getDimension(), n, n2);
        for (int i = n; i <= n2; ++i) {
            realVectorPreservingVisitor.visit(i, this.getEntry(i));
        }
        return realVectorPreservingVisitor.end();
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        return this.walkInDefaultOrder(realVectorPreservingVisitor);
    }

    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(realVectorPreservingVisitor, n, n2);
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        int n = this.getDimension();
        realVectorChangingVisitor.start(n, 0, n - 1);
        for (int i = 0; i < n; ++i) {
            this.setEntry(i, realVectorChangingVisitor.visit(i, this.getEntry(i)));
        }
        return realVectorChangingVisitor.end();
    }

    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(n, n2);
        realVectorChangingVisitor.start(this.getDimension(), n, n2);
        for (int i = n; i <= n2; ++i) {
            this.setEntry(i, realVectorChangingVisitor.visit(i, this.getEntry(i)));
        }
        return realVectorChangingVisitor.end();
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        return this.walkInDefaultOrder(realVectorChangingVisitor);
    }

    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(realVectorChangingVisitor, n, n2);
    }

    public boolean equals(Object object) throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public int hashCode() throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }

    public static RealVector unmodifiableRealVector(final RealVector realVector) {
        return new RealVector(){

            @Override
            public RealVector mapToSelf(UnivariateFunction univariateFunction) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector map(UnivariateFunction univariateFunction) {
                return realVector.map(univariateFunction);
            }

            @Override
            public Iterator<Entry> iterator() {
                final Iterator<Entry> iterator = realVector.iterator();
                return new Iterator<Entry>(){
                    private final UnmodifiableEntry e;
                    {
                        this.e = new UnmodifiableEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Entry next() {
                        this.e.setIndex(((Entry)iterator.next()).getIndex());
                        return this.e;
                    }

                    @Override
                    public void remove() throws MathUnsupportedOperationException {
                        throw new MathUnsupportedOperationException();
                    }
                };
            }

            @Override
            public Iterator<Entry> sparseIterator() {
                final Iterator<Entry> iterator = realVector.sparseIterator();
                return new Iterator<Entry>(){
                    private final UnmodifiableEntry e;
                    {
                        this.e = new UnmodifiableEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Entry next() {
                        this.e.setIndex(((Entry)iterator.next()).getIndex());
                        return this.e;
                    }

                    @Override
                    public void remove() throws MathUnsupportedOperationException {
                        throw new MathUnsupportedOperationException();
                    }
                };
            }

            @Override
            public RealVector copy() {
                return realVector.copy();
            }

            @Override
            public RealVector add(RealVector realVector2) throws DimensionMismatchException {
                return realVector.add(realVector2);
            }

            @Override
            public RealVector subtract(RealVector realVector2) throws DimensionMismatchException {
                return realVector.subtract(realVector2);
            }

            @Override
            public RealVector mapAdd(double d) {
                return realVector.mapAdd(d);
            }

            @Override
            public RealVector mapAddToSelf(double d) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapSubtract(double d) {
                return realVector.mapSubtract(d);
            }

            @Override
            public RealVector mapSubtractToSelf(double d) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapMultiply(double d) {
                return realVector.mapMultiply(d);
            }

            @Override
            public RealVector mapMultiplyToSelf(double d) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector mapDivide(double d) {
                return realVector.mapDivide(d);
            }

            @Override
            public RealVector mapDivideToSelf(double d) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealVector ebeMultiply(RealVector realVector2) throws DimensionMismatchException {
                return realVector.ebeMultiply(realVector2);
            }

            @Override
            public RealVector ebeDivide(RealVector realVector2) throws DimensionMismatchException {
                return realVector.ebeDivide(realVector2);
            }

            @Override
            public double dotProduct(RealVector realVector2) throws DimensionMismatchException {
                return realVector.dotProduct(realVector2);
            }

            @Override
            public double cosine(RealVector realVector2) throws DimensionMismatchException, MathArithmeticException {
                return realVector.cosine(realVector2);
            }

            @Override
            public double getNorm() {
                return realVector.getNorm();
            }

            @Override
            public double getL1Norm() {
                return realVector.getL1Norm();
            }

            @Override
            public double getLInfNorm() {
                return realVector.getLInfNorm();
            }

            @Override
            public double getDistance(RealVector realVector2) throws DimensionMismatchException {
                return realVector.getDistance(realVector2);
            }

            @Override
            public double getL1Distance(RealVector realVector2) throws DimensionMismatchException {
                return realVector.getL1Distance(realVector2);
            }

            @Override
            public double getLInfDistance(RealVector realVector2) throws DimensionMismatchException {
                return realVector.getLInfDistance(realVector2);
            }

            @Override
            public RealVector unitVector() throws MathArithmeticException {
                return realVector.unitVector();
            }

            @Override
            public void unitize() throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public RealMatrix outerProduct(RealVector realVector2) {
                return realVector.outerProduct(realVector2);
            }

            @Override
            public double getEntry(int n) throws OutOfRangeException {
                return realVector.getEntry(n);
            }

            @Override
            public void setEntry(int n, double d) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public void addToEntry(int n, double d) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public int getDimension() {
                return realVector.getDimension();
            }

            @Override
            public RealVector append(RealVector realVector2) {
                return realVector.append(realVector2);
            }

            @Override
            public RealVector append(double d) {
                return realVector.append(d);
            }

            @Override
            public RealVector getSubVector(int n, int n2) throws OutOfRangeException, NotPositiveException {
                return realVector.getSubVector(n, n2);
            }

            @Override
            public void setSubVector(int n, RealVector realVector2) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public void set(double d) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            @Override
            public double[] toArray() {
                return realVector.toArray();
            }

            @Override
            public boolean isNaN() {
                return realVector.isNaN();
            }

            @Override
            public boolean isInfinite() {
                return realVector.isInfinite();
            }

            @Override
            public RealVector combine(double d, double d2, RealVector realVector2) throws DimensionMismatchException {
                return realVector.combine(d, d2, realVector2);
            }

            @Override
            public RealVector combineToSelf(double d, double d2, RealVector realVector2) throws MathUnsupportedOperationException {
                throw new MathUnsupportedOperationException();
            }

            class UnmodifiableEntry
            extends Entry {
                UnmodifiableEntry() {
                }

                @Override
                public double getValue() {
                    return realVector.getEntry(this.getIndex());
                }

                @Override
                public void setValue(double d) throws MathUnsupportedOperationException {
                    throw new MathUnsupportedOperationException();
                }
            }
        };
    }

    protected class SparseEntryIterator
    implements Iterator<Entry> {
        private final int dim;
        private Entry current;
        private Entry next;

        protected SparseEntryIterator() {
            this.dim = RealVector.this.getDimension();
            this.current = new Entry();
            this.next = new Entry();
            if (this.next.getValue() == 0.0) {
                this.advance(this.next);
            }
        }

        protected void advance(Entry entry) {
            if (entry == null) {
                return;
            }
            do {
                entry.setIndex(entry.getIndex() + 1);
            } while (entry.getIndex() < this.dim && entry.getValue() == 0.0);
            if (entry.getIndex() >= this.dim) {
                entry.setIndex(-1);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next.getIndex() >= 0;
        }

        @Override
        public Entry next() {
            int n = this.next.getIndex();
            if (n < 0) {
                throw new NoSuchElementException();
            }
            this.current.setIndex(n);
            this.advance(this.next);
            return this.current;
        }

        @Override
        public void remove() throws MathUnsupportedOperationException {
            throw new MathUnsupportedOperationException();
        }
    }

    protected class Entry {
        private int index;

        public Entry() {
            this.setIndex(0);
        }

        public double getValue() {
            return RealVector.this.getEntry(this.getIndex());
        }

        public void setValue(double d) {
            RealVector.this.setEntry(this.getIndex(), d);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int n) {
            this.index = n;
        }
    }
}

