/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.FastMath;

public class RectangularCholeskyDecomposition {
    private final RealMatrix root;
    private int rank;

    public RectangularCholeskyDecomposition(RealMatrix realMatrix) throws NonPositiveDefiniteMatrixException {
        this(realMatrix, 0.0);
    }

    public RectangularCholeskyDecomposition(RealMatrix realMatrix, double d) throws NonPositiveDefiniteMatrixException {
        int n;
        int n2;
        int n3 = realMatrix.getRowDimension();
        double[][] dArray = realMatrix.getData();
        double[][] dArray2 = new double[n3][n3];
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = n2;
        }
        n2 = 0;
        int n4 = 1;
        while (n4 != 0) {
            double d2;
            int n5;
            n = n2;
            for (n5 = n2 + 1; n5 < n3; ++n5) {
                int n6 = nArray[n5];
                int n7 = nArray[n];
                if (!(dArray[n6][n6] > dArray[n7][n7])) continue;
                n = n5;
            }
            if (n != n2) {
                n5 = nArray[n2];
                nArray[n2] = nArray[n];
                nArray[n] = n5;
                double[] dArray3 = dArray2[n2];
                dArray2[n2] = dArray2[n];
                dArray2[n] = dArray3;
            }
            if (dArray[n5 = nArray[n2]][n5] <= d) {
                if (n2 == 0) {
                    throw new NonPositiveDefiniteMatrixException(dArray[n5][n5], n5, d);
                }
                for (int i = n2; i < n3; ++i) {
                    if (!(dArray[nArray[i]][nArray[i]] < -d)) continue;
                    throw new NonPositiveDefiniteMatrixException(dArray[nArray[i]][nArray[i]], i, d);
                }
                n4 = 0;
                continue;
            }
            dArray2[n2][n2] = d2 = FastMath.sqrt(dArray[n5][n5]);
            double d3 = 1.0 / d2;
            double d4 = 1.0 / dArray[n5][n5];
            for (int i = n2 + 1; i < n3; ++i) {
                double d5;
                int n8 = nArray[i];
                dArray2[i][n2] = d5 = d3 * dArray[n8][n5];
                double[] dArray4 = dArray[n8];
                int n9 = n8;
                dArray4[n9] = dArray4[n9] - dArray[n8][n5] * dArray[n8][n5] * d4;
                for (int j = n2 + 1; j < i; ++j) {
                    double d6;
                    int n10 = nArray[j];
                    dArray[n8][n10] = d6 = dArray[n8][n10] - d5 * dArray2[j][n2];
                    dArray[n10][n8] = d6;
                }
            }
            n4 = ++n2 < n3 ? 1 : 0;
        }
        this.rank = n2;
        this.root = MatrixUtils.createRealMatrix(n3, n2);
        for (n4 = 0; n4 < n3; ++n4) {
            for (n = 0; n < n2; ++n) {
                this.root.setEntry(nArray[n4], n, dArray2[n4][n]);
            }
        }
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }
}

