/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class AhrensDieterExponentialSampler
extends SamplerBase
implements ContinuousSampler {
    private static final double[] EXPONENTIAL_SA_QI = new double[16];
    private final double mean;
    private final UniformRandomProvider rng;

    public AhrensDieterExponentialSampler(UniformRandomProvider uniformRandomProvider, double d) {
        super(null);
        if (d <= 0.0) {
            throw new IllegalArgumentException("mean is not strictly positive: " + d);
        }
        this.rng = uniformRandomProvider;
        this.mean = d;
    }

    @Override
    public double sample() {
        double d;
        double d2;
        double d3 = 0.0;
        for (d2 = this.rng.nextDouble(); d2 < 0.5; d2 *= 2.0) {
            d3 += EXPONENTIAL_SA_QI[0];
        }
        if ((d2 += d2 - 1.0) <= EXPONENTIAL_SA_QI[0]) {
            return this.mean * (d3 + d2);
        }
        int n = 0;
        double d4 = d = this.rng.nextDouble();
        do {
            ++n;
            d = this.rng.nextDouble();
            if (!(d < d4)) continue;
            d4 = d;
        } while (d2 > EXPONENTIAL_SA_QI[n]);
        return this.mean * (d3 + d4 * EXPONENTIAL_SA_QI[0]);
    }

    @Override
    public String toString() {
        return "Ahrens-Dieter Exponential deviate [" + this.rng.toString() + "]";
    }

    static {
        double d = Math.log(2.0);
        double d2 = 0.0;
        for (int i = 0; i < EXPONENTIAL_SA_QI.length; ++i) {
            AhrensDieterExponentialSampler.EXPONENTIAL_SA_QI[i] = d2 += Math.pow(d, i + 1) / (double)InternalUtils.factorial(i + 1);
        }
    }
}

