/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import io.virtdata.annotations.Categories;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Example;
import io.virtdata.annotations.PerThreadMapper;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.processors.DocForFunc;
import io.virtdata.processors.FuncEnumerator;
import io.virtdata.processors.FunctionDocInfoWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedOptions(value={"title"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_12)
@SupportedAnnotationTypes(value={"io.virtdata.annotations.ThreadSafeMapper", "io.virtdata.annotations.PerThreadMapper"})
public class FunctionDocInfoProcessor
extends AbstractProcessor {
    public static final String AUTOSUFFIX = "AutoDocsInfo";
    private static Pattern packageNamePattern = Pattern.compile("(?<packageName>.+)?\\.(?<className>.+)");
    private Filer filer;
    private Map<String, String> options;
    private Elements elementUtils;
    private Messager messenger;
    private SourceVersion sourceVersion;
    private Types typeUtils;
    private FuncEnumerator enumerator;
    private static Pattern inheritDocPattern = Pattern.compile("(?ms)(?<pre>.*)(?<inherit>\\{@inheritDoc})(?<post>.*)$");

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.options = processingEnvironment.getOptions();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.messenger = processingEnvironment.getMessager();
        this.sourceVersion = processingEnvironment.getSourceVersion();
        this.typeUtils = processingEnvironment.getTypeUtils();
        this.enumerator = new FuncEnumerator(this.typeUtils, this.elementUtils, this.filer);
        this.enumerator.addListener(new FunctionDocInfoWriter(this.filer, this.messenger, AUTOSUFFIX));
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.addAll(roundEnvironment.getElementsAnnotatedWith(ThreadSafeMapper.class));
        arrayList.addAll(roundEnvironment.getElementsAnnotatedWith(PerThreadMapper.class));
        for (Element element : arrayList) {
            if (element.getKind() != ElementKind.CLASS) {
                throw new RuntimeException("Unexpected kind of element: " + element.getKind() + " for " + element.toString());
            }
            Name name = ((TypeElement)element).getQualifiedName();
            Matcher matcher = packageNamePattern.matcher(name);
            if (!matcher.matches()) {
                throw new RuntimeException("Unable to match qualified name for package and name: " + name);
            }
            String string = matcher.group("packageName");
            String string2 = matcher.group("className");
            String string3 = this.elementUtils.getDocComment(element);
            string3 = string3 == null ? "" : this.cleanJavadoc(string3);
            string3 = this.inheritDocs(string3, element);
            this.enumerator.onClass(string, string2, string3);
            Categories categories = element.getAnnotation(Categories.class);
            if (categories != null) {
                Category[] categoryArray = categories.value();
                this.enumerator.onCategories(categoryArray);
            }
            boolean bl = false;
            Element object2 = null;
            Element element2 = element;
            while (object2 == null && element2 != null) {
                for (Element element3 : element2.getEnclosedElements()) {
                    if (element3.getKind() != ElementKind.METHOD || !element3.getSimpleName().toString().startsWith("apply")) continue;
                    object2 = element3;
                    break;
                }
                if (object2 != null) break;
                element2 = this.elementUtils.getTypeElement(((TypeElement)element2).getSuperclass().toString());
            }
            if (object2 == null) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, "Unable to enumerate input and output types for " + string2);
                return false;
            }
            VariableElement variableElement = ((ExecutableElement)object2).getParameters().get(0);
            String object3 = variableElement.asType().toString();
            String string4 = ((ExecutableElement)object2).getReturnType().toString();
            this.enumerator.onApplyTypes(object3, string4);
            for (Element element4 : element.getEnclosedElements()) {
                String string5;
                Object object;
                if (element4.getKind() != ElementKind.CONSTRUCTOR) continue;
                List<? extends VariableElement> list = ((ExecutableElement)element4).getParameters();
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                boolean bl2 = ((ExecutableElement)element4).isVarArgs();
                for (int i = 0; i < list.size(); ++i) {
                    object = list.get(i);
                    string5 = object.getSimpleName().toString();
                    String string6 = object.asType().toString() + (i == list.size() - 1 ? (bl2 ? "..." : "") : "");
                    linkedHashMap.put(string5, string6);
                }
                String string7 = this.elementUtils.getDocComment(element4);
                string7 = string7 == null ? "" : this.cleanJavadoc(string7);
                object = new ArrayList();
                for (Example example : string5 = (String)element4.getAnnotationsByType(Example.class)) {
                    example.value();
                    object.add(Arrays.asList(example.value()));
                }
                this.enumerator.onConstructor(linkedHashMap, string7, (List<List<String>>)object);
            }
            this.enumerator.flush();
        }
        return false;
    }

    private String inheritDocs(String string, Element element) {
        if (string == null) {
            return null;
        }
        Matcher matcher = inheritDocPattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = matcher.group("pre");
        String string3 = matcher.group("post");
        Optional<TypeElement> optional = Optional.ofNullable(((TypeElement)element).getSuperclass()).map(String::valueOf).map(this.elementUtils::getTypeElement);
        if (!optional.isPresent()) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Element " + element.toString() + " has '{@inheritDoc}', but a superclass was not found.");
            return string2 + "UNABLE TO FIND ELEMENT TO INHERIT DOCS FROM for " + element.toString() + " " + string3;
        }
        TypeElement typeElement = optional.get();
        String string4 = this.elementUtils.getDocComment(typeElement);
        if (string4 == null) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "javadocs are missing on " + optional.toString() + ", but " + element.toString() + " is trying to inherit docs from it.");
            return string2 + "UNABLE TO FIND INHERITED DOCS for " + element.toString() + " " + string3;
        }
        if (inheritDocPattern.matcher(string4).matches()) {
            return string2 + this.inheritDocs(string4, typeElement) + string3;
        }
        return string2 + string4 + string3;
    }

    private String cleanJavadoc(String string) {
        return string.replaceAll("(?m)^ ", "");
    }

    private static class StdoutListener
    implements FuncEnumerator.Listener {
        private StdoutListener() {
        }

        @Override
        public void onFunctionModel(DocForFunc docForFunc) {
            System.out.println(docForFunc);
        }
    }
}

