/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.LogGamma;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ChengBetaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;

public class BetaDistribution
extends AbstractContinuousDistribution {
    private final double alpha;
    private final double beta;
    private final double z;

    public BetaDistribution(double d, double d2) {
        this.alpha = d;
        this.beta = d2;
        this.z = LogGamma.value(d) + LogGamma.value(d2) - LogGamma.value(d + d2);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    @Override
    public double density(double d) {
        double d2 = this.logDensity(d);
        return d2 == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d2);
    }

    @Override
    public double logDensity(double d) {
        if (d < 0.0 || d > 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 0.0) {
            if (this.alpha < 1.0) {
                throw new DistributionException("{0} < {1}", this.alpha, 1);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            if (this.beta < 1.0) {
                throw new DistributionException("{0} < {1}", this.beta, 1);
            }
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = Math.log(d);
        double d3 = Math.log1p(-d);
        return (this.alpha - 1.0) * d2 + (this.beta - 1.0) * d3 - this.z;
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        return RegularizedBeta.value(d, this.alpha, this.beta);
    }

    @Override
    public double getMean() {
        double d = this.getAlpha();
        return d / (d + this.getBeta());
    }

    @Override
    public double getVariance() {
        double d = this.getAlpha();
        double d2 = this.getBeta();
        double d3 = d + d2;
        return d * d2 / (d3 * d3 * (d3 + 1.0));
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return 1.0;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new ChengBetaSampler(uniformRandomProvider, BetaDistribution.this.alpha, BetaDistribution.this.beta);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

