/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;

public class ExponentialDistribution
extends AbstractContinuousDistribution {
    private final double mean;
    private final double logMean;

    public ExponentialDistribution(double d) {
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        this.mean = d;
        this.logMean = Math.log(d);
    }

    @Override
    public double density(double d) {
        double d2 = this.logDensity(d);
        return d2 == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d2);
    }

    @Override
    public double logDensity(double d) {
        if (d < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return -d / this.mean - this.logMean;
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = d <= 0.0 ? 0.0 : 1.0 - Math.exp(-d / this.mean);
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        double d2 = d == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * Math.log(1.0 - d);
        return d2;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.mean * this.mean;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new AhrensDieterExponentialSampler(uniformRandomProvider, ExponentialDistribution.this.mean);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

