/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.LogBeta;
import org.apache.commons.numbers.gamma.RegularizedBeta;

public class FDistribution
extends AbstractContinuousDistribution {
    private final double numeratorDegreesOfFreedom;
    private final double denominatorDegreesOfFreedom;

    public FDistribution(double d, double d2) {
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.numeratorDegreesOfFreedom = d;
        this.denominatorDegreesOfFreedom = d2;
    }

    @Override
    public double density(double d) {
        return Math.exp(this.logDensity(d));
    }

    @Override
    public double logDensity(double d) {
        double d2 = this.numeratorDegreesOfFreedom / 2.0;
        double d3 = this.denominatorDegreesOfFreedom / 2.0;
        double d4 = Math.log(d);
        double d5 = Math.log(this.numeratorDegreesOfFreedom);
        double d6 = Math.log(this.denominatorDegreesOfFreedom);
        double d7 = Math.log(this.numeratorDegreesOfFreedom * d + this.denominatorDegreesOfFreedom);
        return d2 * d5 + d2 * d4 - d4 + d3 * d6 - d2 * d7 - d3 * d7 - LogBeta.value(d2, d3);
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2;
        if (d <= 0.0) {
            d2 = 0.0;
        } else {
            double d3 = this.numeratorDegreesOfFreedom;
            double d4 = this.denominatorDegreesOfFreedom;
            d2 = RegularizedBeta.value(d3 * d / (d4 + d3 * d), 0.5 * d3, 0.5 * d4);
        }
        return d2;
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    @Override
    public double getMean() {
        double d = this.getDenominatorDegreesOfFreedom();
        if (d > 2.0) {
            return d / (d - 2.0);
        }
        return Double.NaN;
    }

    @Override
    public double getVariance() {
        double d = this.getDenominatorDegreesOfFreedom();
        if (d > 4.0) {
            double d2 = this.getNumeratorDegreesOfFreedom();
            double d3 = d - 2.0;
            return 2.0 * (d * d) * (d2 + d - 2.0) / (d2 * (d3 * d3) * (d - 4.0));
        }
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

