/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;

public class LaplaceDistribution
extends AbstractContinuousDistribution {
    private static final long serialVersionUID = 20160311L;
    private final double mu;
    private final double beta;

    public LaplaceDistribution(double d, double d2) {
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.mu = d;
        this.beta = d2;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double density(double d) {
        return Math.exp(-Math.abs(d - this.mu) / this.beta) / (2.0 * this.beta);
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d <= this.mu) {
            return Math.exp((d - this.mu) / this.beta) / 2.0;
        }
        return 1.0 - Math.exp((this.mu - d) / this.beta) / 2.0;
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = d > 0.5 ? -Math.log(2.0 - 2.0 * d) : Math.log(2.0 * d);
        return this.mu + this.beta * d2;
    }

    @Override
    public double getMean() {
        return this.mu;
    }

    @Override
    public double getVariance() {
        return 2.0 * this.beta * this.beta;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

