/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformParetoSampler;

public class ParetoDistribution
extends AbstractContinuousDistribution {
    private final double scale;
    private final double shape;

    public ParetoDistribution(double d, double d2) {
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.scale = d;
        this.shape = d2;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double density(double d) {
        if (d < this.scale) {
            return 0.0;
        }
        return Math.pow(this.scale, this.shape) / Math.pow(d, this.shape + 1.0) * this.shape;
    }

    @Override
    public double logDensity(double d) {
        if (d < this.scale) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.scale) * this.shape - Math.log(d) * (this.shape + 1.0) + Math.log(this.shape);
    }

    @Override
    public double cumulativeProbability(double d) {
        if (d <= this.scale) {
            return 0.0;
        }
        return 1.0 - Math.pow(this.scale / d, this.shape);
    }

    @Override
    public double getMean() {
        if (this.shape <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.shape * this.scale / (this.shape - 1.0);
    }

    @Override
    public double getVariance() {
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d = this.shape - 1.0;
        return this.scale * this.scale * this.shape / (d * d) / (this.shape - 2.0);
    }

    @Override
    public double getSupportLowerBound() {
        return this.scale;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new InverseTransformParetoSampler(uniformRandomProvider, ParetoDistribution.this.scale, ParetoDistribution.this.shape);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

