/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.polynomials;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;

public class PolynomialFunction
implements UnivariateDifferentiableFunction,
Serializable {
    private static final long serialVersionUID = -7726511984200295583L;
    private final double[] coefficients;

    public PolynomialFunction(double[] dArray) throws NullArgumentException, NoDataException {
        int n;
        MathUtils.checkNotNull(dArray);
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        for (n = dArray.length; n > 1 && dArray[n - 1] == 0.0; --n) {
        }
        this.coefficients = new double[n];
        System.arraycopy(dArray, 0, this.coefficients, 0, n);
    }

    @Override
    public double value(double d) {
        return PolynomialFunction.evaluate(this.coefficients, d);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    protected static double evaluate(double[] dArray, double d) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(dArray);
        int n = dArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        double d2 = dArray[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            d2 = d * d2 + dArray[i];
        }
        return d2;
    }

    @Override
    public DerivativeStructure value(DerivativeStructure derivativeStructure) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(this.coefficients);
        int n = this.coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(derivativeStructure.getFreeParameters(), derivativeStructure.getOrder(), this.coefficients[n - 1]);
        for (int i = n - 2; i >= 0; --i) {
            derivativeStructure2 = derivativeStructure2.multiply(derivativeStructure).add(this.coefficients[i]);
        }
        return derivativeStructure2;
    }

    public PolynomialFunction add(PolynomialFunction polynomialFunction) {
        int n = FastMath.min(this.coefficients.length, polynomialFunction.coefficients.length);
        int n2 = FastMath.max(this.coefficients.length, polynomialFunction.coefficients.length);
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coefficients[i] + polynomialFunction.coefficients[i];
        }
        System.arraycopy(this.coefficients.length < polynomialFunction.coefficients.length ? polynomialFunction.coefficients : this.coefficients, n, dArray, n, n2 - n);
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction subtract(PolynomialFunction polynomialFunction) {
        int n;
        int n2 = FastMath.min(this.coefficients.length, polynomialFunction.coefficients.length);
        int n3 = FastMath.max(this.coefficients.length, polynomialFunction.coefficients.length);
        double[] dArray = new double[n3];
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.coefficients[n] - polynomialFunction.coefficients[n];
        }
        if (this.coefficients.length < polynomialFunction.coefficients.length) {
            for (n = n2; n < n3; ++n) {
                dArray[n] = -polynomialFunction.coefficients[n];
            }
        } else {
            System.arraycopy(this.coefficients, n2, dArray, n2, n3 - n2);
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction negate() {
        double[] dArray = new double[this.coefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            dArray[i] = -this.coefficients[i];
        }
        return new PolynomialFunction(dArray);
    }

    public PolynomialFunction multiply(PolynomialFunction polynomialFunction) {
        double[] dArray = new double[this.coefficients.length + polynomialFunction.coefficients.length - 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
            for (int j = FastMath.max(0, i + 1 - polynomialFunction.coefficients.length); j < FastMath.min(this.coefficients.length, i + 1); ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.coefficients[j] * polynomialFunction.coefficients[i - j];
            }
        }
        return new PolynomialFunction(dArray);
    }

    protected static double[] differentiate(double[] dArray) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(dArray);
        int n = dArray.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] dArray2 = new double[n - 1];
        for (int i = n - 1; i > 0; --i) {
            dArray2[i - 1] = (double)i * dArray[i];
        }
        return dArray2;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.coefficients[0] == 0.0) {
            if (this.coefficients.length == 1) {
                return "0";
            }
        } else {
            stringBuilder.append(PolynomialFunction.toString(this.coefficients[0]));
        }
        for (int i = 1; i < this.coefficients.length; ++i) {
            if (this.coefficients[i] == 0.0) continue;
            if (stringBuilder.length() > 0) {
                if (this.coefficients[i] < 0.0) {
                    stringBuilder.append(" - ");
                } else {
                    stringBuilder.append(" + ");
                }
            } else if (this.coefficients[i] < 0.0) {
                stringBuilder.append("-");
            }
            double d = FastMath.abs(this.coefficients[i]);
            if (d - 1.0 != 0.0) {
                stringBuilder.append(PolynomialFunction.toString(d));
                stringBuilder.append(' ');
            }
            stringBuilder.append("x");
            if (i <= 1) continue;
            stringBuilder.append('^');
            stringBuilder.append(Integer.toString(i));
        }
        return stringBuilder.toString();
    }

    private static String toString(double d) {
        String string = Double.toString(d);
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.coefficients);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PolynomialFunction)) {
            return false;
        }
        PolynomialFunction polynomialFunction = (PolynomialFunction)object;
        return Arrays.equals(this.coefficients, polynomialFunction.coefficients);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double[] gradient(double d, double ... dArray) {
            double[] dArray2 = new double[dArray.length];
            double d2 = 1.0;
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = d2;
                d2 *= d;
            }
            return dArray2;
        }

        @Override
        public double value(double d, double ... dArray) throws NoDataException {
            return PolynomialFunction.evaluate(dArray, d);
        }
    }
}

