/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.solvers;

import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math4.analysis.solvers.AllowedSolution;
import org.apache.commons.math4.analysis.solvers.BracketedUnivariateSolver;
import org.apache.commons.math4.exception.ConvergenceException;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.util.FastMath;

public abstract class BaseSecantSolver
extends AbstractUnivariateSolver
implements BracketedUnivariateSolver<UnivariateFunction> {
    protected static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private AllowedSolution allowed = AllowedSolution.ANY_SIDE;
    private final Method method;

    protected BaseSecantSolver(double d, Method method) {
        super(d);
        this.method = method;
    }

    protected BaseSecantSolver(double d, double d2, Method method) {
        super(d, d2);
        this.method = method;
    }

    protected BaseSecantSolver(double d, double d2, double d3, Method method) {
        super(d, d2, d3);
        this.method = method;
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d, double d2, AllowedSolution allowedSolution) {
        return this.solve(n, univariateFunction, d, d2, d + 0.5 * (d2 - d), allowedSolution);
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d, double d2, double d3, AllowedSolution allowedSolution) {
        this.allowed = allowedSolution;
        return super.solve(n, univariateFunction, d, d2, d3);
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d, double d2, double d3) {
        return this.solve(n, univariateFunction, d, d2, d3, AllowedSolution.ANY_SIDE);
    }

    @Override
    protected final double doSolve() throws ConvergenceException {
        double d = this.getMin();
        double d2 = this.getMax();
        double d3 = this.computeObjectiveValue(d);
        double d4 = this.computeObjectiveValue(d2);
        if (d3 == 0.0) {
            return d;
        }
        if (d4 == 0.0) {
            return d2;
        }
        this.verifyBracketing(d, d2);
        double d5 = this.getFunctionValueAccuracy();
        double d6 = this.getAbsoluteAccuracy();
        double d7 = this.getRelativeAccuracy();
        boolean bl = false;
        block19: do {
            double d8;
            double d9;
            if ((d9 = this.computeObjectiveValue(d8 = d2 - d4 * (d2 - d) / (d4 - d3))) == 0.0) {
                return d8;
            }
            if (d4 * d9 < 0.0) {
                d = d2;
                d3 = d4;
                bl = !bl;
            } else {
                switch (this.method) {
                    case ILLINOIS: {
                        d3 *= 0.5;
                        break;
                    }
                    case PEGASUS: {
                        d3 *= d4 / (d4 + d9);
                        break;
                    }
                    case REGULA_FALSI: {
                        if (d8 != d2) break;
                        throw new ConvergenceException();
                    }
                    default: {
                        throw new MathInternalError();
                    }
                }
            }
            d2 = d8;
            d4 = d9;
            if (!(FastMath.abs(d4) <= d5)) continue;
            switch (this.allowed) {
                case ANY_SIDE: {
                    return d2;
                }
                case LEFT_SIDE: {
                    if (!bl) continue block19;
                    return d2;
                }
                case RIGHT_SIDE: {
                    if (bl) continue block19;
                    return d2;
                }
                case BELOW_SIDE: {
                    if (!(d4 <= 0.0)) continue block19;
                    return d2;
                }
                case ABOVE_SIDE: {
                    if (!(d4 >= 0.0)) continue block19;
                    return d2;
                }
                default: {
                    throw new MathInternalError();
                }
            }
        } while (!(FastMath.abs(d2 - d) < FastMath.max(d7 * FastMath.abs(d2), d6)));
        switch (this.allowed) {
            case ANY_SIDE: {
                return d2;
            }
            case LEFT_SIDE: {
                return bl ? d2 : d;
            }
            case RIGHT_SIDE: {
                return bl ? d : d2;
            }
            case BELOW_SIDE: {
                return d4 <= 0.0 ? d2 : d;
            }
            case ABOVE_SIDE: {
                return d4 >= 0.0 ? d2 : d;
            }
        }
        throw new MathInternalError();
    }

    protected static enum Method {
        REGULA_FALSI,
        ILLINOIS,
        PEGASUS;

    }
}

