/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.solvers;

import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math4.analysis.solvers.AllowedSolution;
import org.apache.commons.math4.analysis.solvers.BracketedUnivariateSolver;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NoBracketingException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.core.Precision;

public class BracketingNthOrderBrentSolver
extends AbstractUnivariateSolver
implements BracketedUnivariateSolver<UnivariateFunction> {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final int DEFAULT_MAXIMAL_ORDER = 5;
    private static final int MAXIMAL_AGING = 2;
    private static final double REDUCTION_FACTOR = 0.0625;
    private final int maximalOrder;
    private AllowedSolution allowed;

    public BracketingNthOrderBrentSolver() {
        this(1.0E-6, 5);
    }

    public BracketingNthOrderBrentSolver(double d, int n) throws NumberIsTooSmallException {
        super(d);
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.maximalOrder = n;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public BracketingNthOrderBrentSolver(double d, double d2, int n) throws NumberIsTooSmallException {
        super(d, d2);
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.maximalOrder = n;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public BracketingNthOrderBrentSolver(double d, double d2, double d3, int n) throws NumberIsTooSmallException {
        super(d, d2, d3);
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        this.maximalOrder = n;
        this.allowed = AllowedSolution.ANY_SIDE;
    }

    public int getMaximalOrder() {
        return this.maximalOrder;
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        int n;
        int n2;
        double[] dArray = new double[this.maximalOrder + 1];
        double[] dArray2 = new double[this.maximalOrder + 1];
        dArray[0] = this.getMin();
        dArray[1] = this.getStartValue();
        dArray[2] = this.getMax();
        this.verifySequence(dArray[0], dArray[1], dArray[2]);
        dArray2[1] = this.computeObjectiveValue(dArray[1]);
        if (Precision.equals(dArray2[1], 0.0, 1)) {
            return dArray[1];
        }
        dArray2[0] = this.computeObjectiveValue(dArray[0]);
        if (Precision.equals(dArray2[0], 0.0, 1)) {
            return dArray[0];
        }
        if (dArray2[0] * dArray2[1] < 0.0) {
            n2 = 2;
            n = 1;
        } else {
            dArray2[2] = this.computeObjectiveValue(dArray[2]);
            if (Precision.equals(dArray2[2], 0.0, 1)) {
                return dArray[2];
            }
            if (dArray2[1] * dArray2[2] < 0.0) {
                n2 = 3;
                n = 2;
            } else {
                throw new NoBracketingException(dArray[0], dArray[2], dArray2[0], dArray2[2]);
            }
        }
        double[] dArray3 = new double[dArray.length];
        double d = dArray[n - 1];
        double d2 = dArray2[n - 1];
        double d3 = FastMath.abs(d2);
        int n3 = 0;
        double d4 = dArray[n];
        double d5 = dArray2[n];
        double d6 = FastMath.abs(d5);
        int n4 = 0;
        while (true) {
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            if (d4 - d <= (d11 = this.getAbsoluteAccuracy() + this.getRelativeAccuracy() * FastMath.max(FastMath.abs(d), FastMath.abs(d4))) || FastMath.max(d3, d6) < this.getFunctionValueAccuracy()) {
                switch (this.allowed) {
                    case ANY_SIDE: {
                        return d3 < d6 ? d : d4;
                    }
                    case LEFT_SIDE: {
                        return d;
                    }
                    case RIGHT_SIDE: {
                        return d4;
                    }
                    case BELOW_SIDE: {
                        return d2 <= 0.0 ? d : d4;
                    }
                    case ABOVE_SIDE: {
                        return d2 < 0.0 ? d4 : d;
                    }
                }
                throw new MathInternalError();
            }
            if (n3 >= 2) {
                int n5 = n3 - 2;
                d10 = (1 << n5) - 1;
                double d12 = n5 + 1;
                d9 = (d10 * d2 - d12 * 0.0625 * d5) / (d10 + d12);
            } else if (n4 >= 2) {
                int n6 = n4 - 2;
                d10 = n6 + 1;
                double d13 = (1 << n6) - 1;
                d9 = (d13 * d5 - d10 * 0.0625 * d2) / (d10 + d13);
            } else {
                d9 = 0.0;
            }
            int n7 = 0;
            int n8 = n2;
            do {
                System.arraycopy(dArray, n7, dArray3, n7, n8 - n7);
                d8 = this.guessX(d9, dArray3, dArray2, n7, n8);
                if (d8 > d && d8 < d4) continue;
                if (n - n7 >= n8 - n) {
                    ++n7;
                } else {
                    --n8;
                }
                d8 = Double.NaN;
            } while (Double.isNaN(d8) && n8 - n7 > 1);
            if (Double.isNaN(d8)) {
                d8 = d + 0.5 * (d4 - d);
                n7 = n - 1;
                n8 = n;
            }
            if (Precision.equals(d7 = this.computeObjectiveValue(d8), 0.0, 1)) {
                return d8;
            }
            if (n2 > 2 && n8 - n7 != n2) {
                n2 = n8 - n7;
                System.arraycopy(dArray, n7, dArray, 0, n2);
                System.arraycopy(dArray2, n7, dArray2, 0, n2);
                n -= n7;
            } else if (n2 == dArray.length) {
                --n2;
                if (n >= (dArray.length + 1) / 2) {
                    System.arraycopy(dArray, 1, dArray, 0, n2);
                    System.arraycopy(dArray2, 1, dArray2, 0, n2);
                    --n;
                }
            }
            System.arraycopy(dArray, n, dArray, n + 1, n2 - n);
            dArray[n] = d8;
            System.arraycopy(dArray2, n, dArray2, n + 1, n2 - n);
            dArray2[n] = d7;
            ++n2;
            if (d7 * d2 <= 0.0) {
                d4 = d8;
                d5 = d7;
                d6 = FastMath.abs(d5);
                ++n3;
                n4 = 0;
                continue;
            }
            d = d8;
            d2 = d7;
            d3 = FastMath.abs(d2);
            n3 = 0;
            ++n4;
            ++n;
        }
    }

    private double guessX(double d, double[] dArray, double[] dArray2, int n, int n2) {
        int n3;
        for (int i = n; i < n2 - 1; ++i) {
            int n4 = i + 1 - n;
            for (n3 = n2 - 1; n3 > i; --n3) {
                dArray[n3] = (dArray[n3] - dArray[n3 - 1]) / (dArray2[n3] - dArray2[n3 - n4]);
            }
        }
        double d2 = 0.0;
        for (n3 = n2 - 1; n3 >= n; --n3) {
            d2 = dArray[n3] + d2 * (d - dArray2[n3]);
        }
        return d2;
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d, double d2, AllowedSolution allowedSolution) throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        this.allowed = allowedSolution;
        return super.solve(n, univariateFunction, d, d2);
    }

    @Override
    public double solve(int n, UnivariateFunction univariateFunction, double d, double d2, double d3, AllowedSolution allowedSolution) throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        this.allowed = allowedSolution;
        return super.solve(n, univariateFunction, d, d2, d3);
    }
}

