/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.solvers;

import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.analysis.solvers.AbstractUnivariateDifferentiableSolver;
import org.apache.commons.math4.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.util.FastMath;

public class NewtonRaphsonSolver
extends AbstractUnivariateDifferentiableSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public NewtonRaphsonSolver() {
        this(1.0E-6);
    }

    public NewtonRaphsonSolver(double d) {
        super(d);
    }

    @Override
    public double solve(int n, UnivariateDifferentiableFunction univariateDifferentiableFunction, double d, double d2) throws TooManyEvaluationsException {
        return super.solve(n, univariateDifferentiableFunction, UnivariateSolverUtils.midpoint(d, d2));
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException {
        double d = this.getStartValue();
        double d2 = this.getAbsoluteAccuracy();
        double d3 = d;
        while (true) {
            DerivativeStructure derivativeStructure = this.computeObjectiveValueAndDerivative(d3);
            int[] nArray = new int[]{1};
            double d4 = d3 - derivativeStructure.getValue() / derivativeStructure.getPartialDerivative(nArray);
            if (FastMath.abs(d4 - d3) <= d2) {
                return d4;
            }
            d3 = d4;
        }
    }
}

