/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.MathUnsupportedOperationException;
import org.apache.commons.math4.linear.IterativeLinearSolverEvent;
import org.apache.commons.math4.linear.RealVector;

public class DefaultIterativeLinearSolverEvent
extends IterativeLinearSolverEvent {
    private static final long serialVersionUID = 20120129L;
    private final RealVector b;
    private final RealVector r;
    private final double rnorm;
    private final RealVector x;

    public DefaultIterativeLinearSolverEvent(Object object, int n, RealVector realVector, RealVector realVector2, RealVector realVector3, double d) {
        super(object, n);
        this.x = realVector;
        this.b = realVector2;
        this.r = realVector3;
        this.rnorm = d;
    }

    public DefaultIterativeLinearSolverEvent(Object object, int n, RealVector realVector, RealVector realVector2, double d) {
        super(object, n);
        this.x = realVector;
        this.b = realVector2;
        this.r = null;
        this.rnorm = d;
    }

    @Override
    public double getNormOfResidual() {
        return this.rnorm;
    }

    @Override
    public RealVector getResidual() {
        if (this.r != null) {
            return this.r;
        }
        throw new MathUnsupportedOperationException();
    }

    @Override
    public RealVector getRightHandSideVector() {
        return this.b;
    }

    @Override
    public RealVector getSolution() {
        return this.x;
    }

    @Override
    public boolean providesResidual() {
        return this.r != null;
    }
}

