/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.combinatorics.Factorial;

public class FactorialDouble {
    private static final int FACTORIALS_LONG_CACHE_SIZE = 21;
    private final double[] factorialsDouble;

    private FactorialDouble(int n, double[] dArray) {
        int n2;
        int n3;
        if (n < 0) {
            throw new CombinatoricsException("Number {0} is negative", n);
        }
        this.factorialsDouble = new double[n];
        int n4 = n3 = n < 2 ? n : 2;
        for (n2 = 0; n2 < n3; ++n2) {
            this.factorialsDouble[n2] = 1.0;
        }
        n2 = dArray == null || dArray.length <= 2 ? 2 : (dArray.length <= n ? dArray.length : n);
        for (n3 = 2; n3 < n2; ++n3) {
            this.factorialsDouble[n3] = dArray[n3];
        }
        for (n3 = n2; n3 < n; ++n3) {
            this.factorialsDouble[n3] = (double)n3 * this.factorialsDouble[n3 - 1];
        }
    }

    public static FactorialDouble create() {
        return new FactorialDouble(0, null);
    }

    public FactorialDouble withCache(int n) {
        return new FactorialDouble(n, this.factorialsDouble);
    }

    public double value(int n) {
        if (n < 21) {
            return Factorial.value(n);
        }
        if (n < this.factorialsDouble.length) {
            return this.factorialsDouble[n];
        }
        return this.compute(n);
    }

    private double compute(int n) {
        int n2 = 2;
        double d = 1.0;
        if (this.factorialsDouble.length > 2) {
            d = this.factorialsDouble[this.factorialsDouble.length - 1];
            n2 = this.factorialsDouble.length;
        }
        for (int i = n2; i <= n; ++i) {
            d *= (double)i;
        }
        return d;
    }
}

