/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.fraction.ContinuedFraction;
import org.apache.commons.numbers.gamma.GammaException;
import org.apache.commons.numbers.gamma.LogGamma;

public class RegularizedGamma {
    private static final double DEFAULT_EPSILON = 1.0E-15;

    public static class Q {
        public static double value(double d, double d2) {
            return Q.value(d, d2, 1.0E-15, Integer.MAX_VALUE);
        }

        public static double value(final double d, double d2, double d3, int n) {
            if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 < 0.0) {
                return Double.NaN;
            }
            if (d2 == 0.0) {
                return 1.0;
            }
            if (d2 < d + 1.0) {
                return 1.0 - P.value(d, d2, d3, n);
            }
            ContinuedFraction continuedFraction = new ContinuedFraction(){

                @Override
                protected double getA(int n, double d2) {
                    return (double)(2 * n + 1) - d + d2;
                }

                @Override
                protected double getB(int n, double d2) {
                    return (double)n * (d - (double)n);
                }
            };
            return Math.exp(-d2 + d * Math.log(d2) - LogGamma.value(d)) / continuedFraction.evaluate(d2, d3, n);
        }
    }

    public static class P {
        public static double value(double d, double d2) {
            return P.value(d, d2, 1.0E-15, Integer.MAX_VALUE);
        }

        public static double value(double d, double d2, double d3, int n) {
            double d4;
            double d5;
            if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 < 0.0) {
                return Double.NaN;
            }
            if (d2 == 0.0) {
                return 0.0;
            }
            if (d2 >= d + 1.0) {
                return 1.0 - Q.value(d, d2, d3, n);
            }
            double d6 = 0.0;
            for (d4 = d5 = 1.0 / d; Math.abs(d5 / d4) > d3 && d6 < (double)n && d4 < Double.POSITIVE_INFINITY; d4 += (d5 *= d2 / (d + (d6 += 1.0)))) {
            }
            if (d6 >= (double)n) {
                throw new GammaException("Failed to converge within {0} iterations", n);
            }
            if (Double.isInfinite(d4)) {
                return 1.0;
            }
            return Math.exp(-d2 + d * Math.log(d2) - LogGamma.value(d)) * d4;
        }
    }
}

