/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

public class Trigamma {
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;
    private static final double F_1_6 = 0.16666666666666666;
    private static final double F_1_30 = 0.03333333333333333;
    private static final double F_1_42 = 0.023809523809523808;

    public static double value(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d;
        }
        if (d > 0.0 && d <= 1.0E-5) {
            return 1.0 / (d * d);
        }
        if (d >= 49.0) {
            double d2 = 1.0 / (d * d);
            return 1.0 / d + d2 / 2.0 + d2 / d * (0.16666666666666666 - d2 * (0.03333333333333333 + 0.023809523809523808 * d2));
        }
        return Trigamma.value(d + 1.0) + 1.0 / (d * d);
    }
}

