/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.BaseProvider;
import org.apache.commons.rng.core.source32.RandomIntSource;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class IntProvider
extends BaseProvider
implements RandomIntSource {
    private int booleanSource;
    private int booleanBitMask;

    @Override
    protected byte[] getStateInternal() {
        int[] nArray = new int[]{this.booleanSource, this.booleanBitMask};
        return this.composeStateInternal(super.getStateInternal(), NumberFactory.makeByteArray(nArray));
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 8);
        int[] nArray = NumberFactory.makeIntArray(byArray2[0]);
        this.booleanSource = nArray[0];
        this.booleanBitMask = nArray[1];
        super.setStateInternal(byArray2[1]);
    }

    @Override
    public int nextInt() {
        return this.next();
    }

    @Override
    public boolean nextBoolean() {
        this.booleanBitMask <<= 1;
        if (this.booleanBitMask == 0) {
            this.booleanBitMask = 1;
            this.booleanSource = this.nextInt();
        }
        return (this.booleanSource & this.booleanBitMask) != 0;
    }

    @Override
    public double nextDouble() {
        return NumberFactory.makeDouble(this.nextInt(), this.nextInt());
    }

    @Override
    public float nextFloat() {
        return NumberFactory.makeFloat(this.nextInt());
    }

    @Override
    public long nextLong() {
        return NumberFactory.makeLong(this.nextInt(), this.nextInt());
    }

    @Override
    public void nextBytes(byte[] byArray) {
        IntProvider.nextBytesFill(this, byArray, 0, byArray.length);
    }

    @Override
    public void nextBytes(byte[] byArray, int n, int n2) {
        this.checkIndex(0, byArray.length - 1, n);
        this.checkIndex(0, byArray.length - n, n2);
        IntProvider.nextBytesFill(this, byArray, n, n2);
    }

    static void nextBytesFill(RandomIntSource randomIntSource, byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = n4 + (n2 & 0x7FFFFFFC);
        while (n4 < n5) {
            n3 = randomIntSource.next();
            byArray[n4++] = (byte)n3;
            byArray[n4++] = (byte)(n3 >>> 8);
            byArray[n4++] = (byte)(n3 >>> 16);
            byArray[n4++] = (byte)(n3 >>> 24);
        }
        n3 = n + n2;
        if (n4 < n3) {
            int n6 = randomIntSource.next();
            while (true) {
                byArray[n4++] = (byte)n6;
                if (n4 >= n3) break;
                n6 >>>= 8;
            }
        }
    }
}

