/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.util.Arrays;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class MultiplyWithCarry256
extends IntProvider {
    private static final int Q_SIZE = 256;
    private static final int SEED_SIZE = 257;
    private static final long A = 809430660L;
    private final int[] state = new int[256];
    private int index;
    private int carry;

    public MultiplyWithCarry256(int[] nArray) {
        this.setSeedInternal(nArray);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] nArray = Arrays.copyOf(this.state, 258);
        nArray[256] = this.carry;
        nArray[257] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(nArray), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 1032);
        int[] nArray = NumberFactory.makeIntArray(byArray2[0]);
        System.arraycopy(nArray, 0, this.state, 0, 256);
        this.carry = nArray[256];
        this.index = nArray[257];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(int[] nArray) {
        int[] nArray2 = new int[257];
        this.fillState(nArray2, nArray);
        int n = nArray2[0];
        this.carry = (int)((long)Math.abs(n) % 809430660L);
        System.arraycopy(nArray2, 1, this.state, 0, 256);
        this.index = 256;
    }

    @Override
    public int next() {
        this.index &= 0xFF;
        long l = 809430660L * ((long)this.state[this.index] & 0xFFFFFFFFL) + (long)this.carry;
        this.carry = (int)(l >> 32);
        int n = (int)l;
        this.state[this.index++] = n;
        return n;
    }
}

