/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.Arrays;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class XorShift1024Star
extends LongProvider {
    private static final int SEED_SIZE = 16;
    private final long[] state = new long[16];
    private final long multiplier;
    private int index;

    public XorShift1024Star(long[] lArray) {
        this(lArray, 1181783497276652981L);
    }

    protected XorShift1024Star(long[] lArray, long l) {
        this.setSeedInternal(lArray);
        this.multiplier = l;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] lArray = Arrays.copyOf(this.state, 17);
        lArray[16] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(lArray), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 136);
        long[] lArray = NumberFactory.makeLongArray(byArray2[0]);
        System.arraycopy(lArray, 0, this.state, 0, 16);
        this.index = (int)lArray[16];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(long[] lArray) {
        this.fillState(this.state, lArray);
        this.index = 0;
    }

    @Override
    public long next() {
        long l = this.state[this.index];
        this.index = this.index + 1 & 0xF;
        long l2 = this.state[this.index];
        l2 ^= l2 << 31;
        this.state[this.index] = l2 ^ l ^ l2 >>> 11 ^ l >>> 30;
        return this.state[this.index] * this.multiplier;
    }
}

