/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.PermutationSampler;

public class ListSampler {
    private ListSampler() {
    }

    public static <T> List<T> sample(UniformRandomProvider uniformRandomProvider, List<T> list, int n) {
        int n2 = list.size();
        PermutationSampler permutationSampler = new PermutationSampler(uniformRandomProvider, n2, n);
        ArrayList<T> arrayList = new ArrayList<T>(n);
        int[] nArray = permutationSampler.sample();
        for (int i = 0; i < n; ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        return arrayList;
    }

    public static <T> void shuffle(UniformRandomProvider uniformRandomProvider, List<T> list) {
        ListSampler.shuffle(uniformRandomProvider, list, 0, false);
    }

    public static <T> void shuffle(UniformRandomProvider uniformRandomProvider, List<T> list, int n, boolean bl) {
        int n2 = list.size();
        int[] nArray = PermutationSampler.natural(n2);
        PermutationSampler.shuffle(uniformRandomProvider, nArray, n, bl);
        ArrayList<T> arrayList = new ArrayList<T>(list);
        for (int i = 0; i < n2; ++i) {
            list.set(i, arrayList.get(nArray[i]));
        }
    }
}

