/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;

public class GaussianSampler
implements ContinuousSampler {
    private final double mean;
    private final double standardDeviation;
    private final NormalizedGaussianSampler normalized;

    public GaussianSampler(NormalizedGaussianSampler normalizedGaussianSampler, double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("standard deviation is not strictly positive: " + d2);
        }
        this.normalized = normalizedGaussianSampler;
        this.mean = d;
        this.standardDeviation = d2;
    }

    @Override
    public double sample() {
        return this.standardDeviation * this.normalized.sample() + this.mean;
    }

    public String toString() {
        return "Gaussian deviate [" + this.normalized.toString() + "]";
    }
}

