/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class InverseTransformParetoSampler
extends SamplerBase
implements ContinuousSampler {
    private final double scale;
    private final double oneOverShape;
    private final UniformRandomProvider rng;

    public InverseTransformParetoSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
        super(null);
        if (d <= 0.0) {
            throw new IllegalArgumentException("scale is not strictly positive: " + d);
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("shape is not strictly positive: " + d2);
        }
        this.rng = uniformRandomProvider;
        this.scale = d;
        this.oneOverShape = 1.0 / d2;
    }

    @Override
    public double sample() {
        return this.scale / Math.pow(this.rng.nextDouble(), this.oneOverShape);
    }

    @Override
    public String toString() {
        return "[Inverse method for Pareto distribution " + this.rng.toString() + "]";
    }
}

