/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.long_long;

import io.virtdata.discrete.common.DiscreteLongLongSampler;
import io.virtdata.discrete.common.IntegerDistributionICDSource;
import io.virtdata.discrete.common.InterpolatingLongLongSampler;
import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongUnaryOperator;

public class LongToLongDiscreteCurve
implements LongUnaryOperator {
    private DiscreteDistribution distribution;
    private LongUnaryOperator function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(LongToLongDiscreteCurve.COMPUTE);
            this.add(LongToLongDiscreteCurve.INTERPOLATE);
            this.add(LongToLongDiscreteCurve.MAP);
            this.add(LongToLongDiscreteCurve.HASH);
        }
    };

    public LongToLongDiscreteCurve(DiscreteDistribution discreteDistribution, String ... stringArray) {
        this.distribution = discreteDistribution;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        IntegerDistributionICDSource integerDistributionICDSource = new IntegerDistributionICDSource(discreteDistribution);
        if (hashSet.contains(HASH) && hashSet.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (hashSet.contains(INTERPOLATE) && hashSet.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        for (String string : stringArray) {
            if (validModifiers.contains(string)) continue;
            throw new RuntimeException("modifier '" + string + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean bl = hashSet.contains(HASH) || !hashSet.contains(MAP);
        int n = hashSet.contains(INTERPOLATE) || !hashSet.contains(COMPUTE) ? 1 : 0;
        this.function = n != 0 ? new InterpolatingLongLongSampler(integerDistributionICDSource, 1000, bl) : new DiscreteLongLongSampler(integerDistributionICDSource, bl);
    }

    @Override
    public long applyAsLong(long l) {
        return this.function.applyAsLong(l);
    }
}

