/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathUtils;

public class Frequency<T extends Comparable<T>>
implements Serializable {
    private static final long serialVersionUID = 605878194679954450L;
    private final SortedMap<T, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap<T, Long>();
    }

    public Frequency(Comparator<T> comparator) {
        this.freqTable = new TreeMap<T, Long>(comparator);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        for (Comparable comparable : this.freqTable.keySet()) {
            stringBuilder.append(comparable);
            stringBuilder.append('\t');
            stringBuilder.append(this.getCount(comparable));
            stringBuilder.append('\t');
            stringBuilder.append(numberFormat.format(this.getPct(comparable)));
            stringBuilder.append('\t');
            stringBuilder.append(numberFormat.format(this.getCumPct(comparable)));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void addValue(T t) {
        this.incrementValue(t, 1L);
    }

    public void incrementValue(T t, long l) {
        Long l2 = (Long)this.freqTable.get(t);
        if (l2 == null) {
            this.freqTable.put(t, l);
        } else {
            this.freqTable.put(t, l2 + l);
        }
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<T> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public Iterator<Map.Entry<T, Long>> entrySetIterator() {
        return this.freqTable.entrySet().iterator();
    }

    public long getSumFreq() {
        long l = 0L;
        Iterator<Long> iterator = this.freqTable.values().iterator();
        while (iterator.hasNext()) {
            l += iterator.next().longValue();
        }
        return l;
    }

    public long getCount(T t) {
        long l = 0L;
        Long l2 = (Long)this.freqTable.get(t);
        if (l2 != null) {
            l = l2;
        }
        return l;
    }

    public int getUniqueCount() {
        return this.freqTable.keySet().size();
    }

    public double getPct(T t) {
        long l = this.getSumFreq();
        if (l == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(t) / (double)l;
    }

    public long getCumFreq(T t) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        Comparator<T> comparator = this.freqTable.comparator();
        if (comparator == null) {
            comparator = new NaturalComparator<T>();
        }
        long l = 0L;
        Long l2 = (Long)this.freqTable.get(t);
        if (l2 != null) {
            l = l2;
        }
        if (comparator.compare(t, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (comparator.compare(t, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        Iterator<T> iterator = this.valuesIterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            if (comparator.compare(t, comparable) > 0) {
                l += this.getCount(comparable);
                continue;
            }
            return l;
        }
        return l;
    }

    public double getCumPct(T t) {
        long l = this.getSumFreq();
        if (l == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(t) / (double)l;
    }

    public List<T> getMode() {
        long l = 0L;
        for (Long object : this.freqTable.values()) {
            long entry = object;
            if (entry <= l) continue;
            l = entry;
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<T, Long> entry : this.freqTable.entrySet()) {
            long l2 = entry.getValue();
            if (l2 != l) continue;
            arrayList.add((Comparable)entry.getKey());
        }
        return arrayList;
    }

    public void merge(Frequency<T> frequency) throws NullArgumentException {
        MathUtils.checkNotNull(frequency, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        Iterator<Map.Entry<T, Long>> iterator = frequency.entrySetIterator();
        while (iterator.hasNext()) {
            Map.Entry<T, Long> entry = iterator.next();
            this.incrementValue((Comparable)entry.getKey(), entry.getValue());
        }
    }

    public void merge(Collection<Frequency<T>> collection) throws NullArgumentException {
        MathUtils.checkNotNull(collection, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        for (Frequency<T> frequency : collection) {
            this.merge(frequency);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Frequency)) {
            return false;
        }
        Frequency frequency = (Frequency)object;
        return !(this.freqTable == null ? frequency.freqTable != null : !this.freqTable.equals(frequency.freqTable));
    }

    private static class NaturalComparator<U extends Comparable<U>>
    implements Comparator<U>,
    Serializable {
        private static final long serialVersionUID = -3852193713161395148L;

        private NaturalComparator() {
        }

        @Override
        public int compare(U u, U u2) {
            return u.compareTo(u2);
        }
    }
}

