/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.correlation;

import io.virtdata.shaded.oac.statistics.correlation.Covariance;
import io.virtdata.shaded.oac.statistics.correlation.StorelessBivariateCovariance;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathUnsupportedOperationException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;

public class StorelessCovariance
extends Covariance {
    private StorelessBivariateCovariance[] covMatrix;
    private int dimension;

    public StorelessCovariance(int n) {
        this(n, true);
    }

    public StorelessCovariance(int n, boolean bl) {
        this.dimension = n;
        this.covMatrix = new StorelessBivariateCovariance[this.dimension * (this.dimension + 1) / 2];
        this.initializeMatrix(bl);
    }

    private void initializeMatrix(boolean bl) {
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                this.setElement(i, j, new StorelessBivariateCovariance(bl));
            }
        }
    }

    private int indexOf(int n, int n2) {
        return n2 < n ? n * (n + 1) / 2 + n2 : n2 * (n2 + 1) / 2 + n;
    }

    private StorelessBivariateCovariance getElement(int n, int n2) {
        return this.covMatrix[this.indexOf(n, n2)];
    }

    private void setElement(int n, int n2, StorelessBivariateCovariance storelessBivariateCovariance) {
        this.covMatrix[this.indexOf((int)n, (int)n2)] = storelessBivariateCovariance;
    }

    public double getCovariance(int n, int n2) throws NumberIsTooSmallException {
        return this.getElement(n, n2).getResult();
    }

    public void increment(double[] dArray) throws DimensionMismatchException {
        int n = dArray.length;
        if (n != this.dimension) {
            throw new DimensionMismatchException(n, this.dimension);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                this.getElement(i, j).increment(dArray[i], dArray[j]);
            }
        }
    }

    public void append(StorelessCovariance storelessCovariance) throws DimensionMismatchException {
        if (storelessCovariance.dimension != this.dimension) {
            throw new DimensionMismatchException(storelessCovariance.dimension, this.dimension);
        }
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = i; j < this.dimension; ++j) {
                this.getElement(i, j).append(storelessCovariance.getElement(i, j));
            }
        }
    }

    @Override
    public RealMatrix getCovarianceMatrix() throws NumberIsTooSmallException {
        return MatrixUtils.createRealMatrix(this.getData());
    }

    public double[][] getData() throws NumberIsTooSmallException {
        double[][] dArray = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                dArray[i][j] = this.getElement(i, j).getResult();
            }
        }
        return dArray;
    }

    @Override
    public int getN() throws MathUnsupportedOperationException {
        throw new MathUnsupportedOperationException();
    }
}

