/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive;

import io.virtdata.shaded.oac.statistics.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.numbers.core.Precision;

public abstract class AbstractStorelessUnivariateStatistic
implements StorelessUnivariateStatistic {
    @Override
    public double evaluate(double[] dArray) throws MathIllegalArgumentException {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return this.evaluate(dArray, 0, dArray.length);
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(dArray, n, n2)) {
            StorelessUnivariateStatistic storelessUnivariateStatistic = this.copy();
            storelessUnivariateStatistic.clear();
            storelessUnivariateStatistic.incrementAll(dArray, n, n2);
            return storelessUnivariateStatistic.getResult();
        }
        return Double.NaN;
    }

    @Override
    public abstract StorelessUnivariateStatistic copy();

    @Override
    public abstract void clear();

    @Override
    public abstract double getResult();

    @Override
    public abstract void increment(double var1);

    @Override
    public void incrementAll(double[] dArray) throws MathIllegalArgumentException {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        this.incrementAll(dArray, 0, dArray.length);
    }

    @Override
    public void incrementAll(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues(dArray, n, n2)) {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.increment(dArray[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        StorelessUnivariateStatistic storelessUnivariateStatistic = (StorelessUnivariateStatistic)object;
        return Precision.equalsIncludingNaN(storelessUnivariateStatistic.getResult(), this.getResult()) && Precision.equalsIncludingNaN(storelessUnivariateStatistic.getN(), this.getN());
    }

    public int hashCode() {
        return 31 * (31 + MathUtils.hash(this.getResult())) + MathUtils.hash(this.getN());
    }
}

