/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.ErfDifference;
import org.apache.commons.numbers.gamma.Erfc;
import org.apache.commons.numbers.gamma.InverseErf;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.GaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class NormalDistribution
extends AbstractContinuousDistribution {
    private static final double SQRT2 = Math.sqrt(2.0);
    private final double mean;
    private final double standardDeviation;
    private final double logStandardDeviationPlusHalfLog2Pi;

    public NormalDistribution(double d, double d2) {
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.mean = d;
        this.standardDeviation = d2;
        this.logStandardDeviationPlusHalfLog2Pi = Math.log(d2) + 0.5 * Math.log(Math.PI * 2);
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double density(double d) {
        return Math.exp(this.logDensity(d));
    }

    @Override
    public double logDensity(double d) {
        double d2 = d - this.mean;
        double d3 = d2 / this.standardDeviation;
        return -0.5 * d3 * d3 - this.logStandardDeviationPlusHalfLog2Pi;
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = d - this.mean;
        if (Math.abs(d2) > 40.0 * this.standardDeviation) {
            return d2 < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 * Erfc.value(-d2 / (this.standardDeviation * SQRT2));
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        return this.mean + this.standardDeviation * SQRT2 * InverseErf.value(2.0 * d - 1.0);
    }

    @Override
    public double probability(double d, double d2) {
        if (d > d2) {
            throw new DistributionException("{0} > {1}", d, d2);
        }
        double d3 = this.standardDeviation * SQRT2;
        double d4 = (d - this.mean) / d3;
        double d5 = (d2 - this.mean) / d3;
        return 0.5 * ErfDifference.value(d4, d5);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        double d = this.getStandardDeviation();
        return d * d;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new GaussianSampler(new ZigguratNormalizedGaussianSampler(uniformRandomProvider), NormalDistribution.this.mean, NormalDistribution.this.standardDeviation);
            }

            @Override
            public double sample() {
                return this.sampler.sample();
            }
        };
    }
}

