/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;

public class UniformDiscreteDistribution
extends AbstractDiscreteDistribution {
    private static final double ONE_TWELFTH = 0.08333333333333333;
    private final int lower;
    private final int upper;
    private final double upperPlusLower;
    private final double upperMinusLower;

    public UniformDiscreteDistribution(int n, int n2) {
        if (n > n2) {
            throw new DistributionException("{0} > {1}", n, n2);
        }
        this.lower = n;
        this.upper = n2;
        this.upperPlusLower = (double)n2 + (double)n;
        this.upperMinusLower = (double)n2 - (double)n;
    }

    @Override
    public double probability(int n) {
        if (n < this.lower || n > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upperMinusLower + 1.0);
    }

    @Override
    public double cumulativeProbability(int n) {
        if (n < this.lower) {
            return 0.0;
        }
        if (n > this.upper) {
            return 1.0;
        }
        return (double)(n - this.lower + 1) / (this.upperMinusLower + 1.0);
    }

    @Override
    public double getMean() {
        return 0.5 * this.upperPlusLower;
    }

    @Override
    public double getVariance() {
        double d = this.upperMinusLower + 1.0;
        return 0.08333333333333333 * (d * d - 1.0);
    }

    @Override
    public int getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public int getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new DiscreteUniformSampler(uniformRandomProvider, UniformDiscreteDistribution.this.lower, UniformDiscreteDistribution.this.upper);
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }
}

