/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration;

import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.integration.UnivariateIntegrator;
import org.apache.commons.math4.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.util.Incrementor;
import org.apache.commons.math4.util.MathUtils;

public abstract class BaseAbstractUnivariateIntegrator
implements UnivariateIntegrator {
    public static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-15;
    public static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-6;
    public static final int DEFAULT_MIN_ITERATIONS_COUNT = 3;
    public static final int DEFAULT_MAX_ITERATIONS_COUNT = Integer.MAX_VALUE;
    protected final Incrementor iterations;
    private final double absoluteAccuracy;
    private final double relativeAccuracy;
    private final int minimalIterationCount;
    private final Incrementor evaluations;
    private UnivariateFunction function;
    private double min;
    private double max;

    protected BaseAbstractUnivariateIntegrator(double d, double d2, int n, int n2) throws NotStrictlyPositiveException, NumberIsTooSmallException {
        this.relativeAccuracy = d;
        this.absoluteAccuracy = d2;
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        if (n2 <= n) {
            throw new NumberIsTooSmallException(n2, (Number)n, false);
        }
        this.minimalIterationCount = n;
        this.iterations = new Incrementor();
        this.iterations.setMaximalCount(n2);
        this.evaluations = new Incrementor();
    }

    protected BaseAbstractUnivariateIntegrator(double d, double d2) {
        this(d, d2, 3, Integer.MAX_VALUE);
    }

    protected BaseAbstractUnivariateIntegrator(int n, int n2) throws NotStrictlyPositiveException, NumberIsTooSmallException {
        this(1.0E-6, 1.0E-15, n, n2);
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    @Override
    public int getMaximalIterationCount() {
        return this.iterations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public int getIterations() {
        return this.iterations.getCount();
    }

    protected double getMin() {
        return this.min;
    }

    protected double getMax() {
        return this.max;
    }

    protected double computeObjectiveValue(double d) throws TooManyEvaluationsException {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
        return this.function.value(d);
    }

    protected void setup(int n, UnivariateFunction univariateFunction, double d, double d2) throws NullArgumentException, MathIllegalArgumentException {
        MathUtils.checkNotNull(univariateFunction);
        UnivariateSolverUtils.verifyInterval(d, d2);
        this.min = d;
        this.max = d2;
        this.function = univariateFunction;
        this.evaluations.setMaximalCount(n);
        this.evaluations.resetCount();
        this.iterations.resetCount();
    }

    @Override
    public double integrate(int n, UnivariateFunction univariateFunction, double d, double d2) throws TooManyEvaluationsException, MaxCountExceededException, MathIllegalArgumentException, NullArgumentException {
        this.setup(n, univariateFunction, d, d2);
        return this.doIntegrate();
    }

    protected abstract double doIntegrate() throws TooManyEvaluationsException, MaxCountExceededException;
}

