/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import org.apache.commons.math4.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math4.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathArrays;

public class PiecewiseBicubicSplineInterpolator
implements BivariateGridInterpolator {
    @Override
    public PiecewiseBicubicSplineInterpolatingFunction interpolate(double[] dArray, double[] dArray2, double[][] dArray3) throws DimensionMismatchException, NullArgumentException, NoDataException, NonMonotonicSequenceException {
        if (dArray == null || dArray2 == null || dArray3 == null || dArray3[0] == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0) {
            throw new NoDataException();
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        return new PiecewiseBicubicSplineInterpolatingFunction(dArray, dArray2, dArray3);
    }
}

