/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.io.Serializable;
import org.apache.commons.math4.Field;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathIllegalStateException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.AbstractFieldMatrix;
import org.apache.commons.math4.linear.FieldMatrix;
import org.apache.commons.math4.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math4.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math4.linear.MatrixDimensionMismatchException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    private T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int n, int n2) throws NotStrictlyPositiveException {
        super(field, n, n2);
        this.data = (FieldElement[][])MathArrays.buildArray(field, n, n2);
    }

    public Array2DRowFieldMatrix(T[][] TArray) throws DimensionMismatchException, NullArgumentException, NoDataException {
        this(Array2DRowFieldMatrix.extractField(TArray), (FieldElement[][])TArray);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] TArray) throws DimensionMismatchException, NullArgumentException, NoDataException {
        super(field);
        this.copyIn((FieldElement[][])TArray);
    }

    public Array2DRowFieldMatrix(T[][] TArray, boolean bl) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this(Array2DRowFieldMatrix.extractField(TArray), (FieldElement[][])TArray, bl);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[][] TArray, boolean bl) throws DimensionMismatchException, NoDataException, NullArgumentException {
        super(field);
        if (bl) {
            this.copyIn((FieldElement[][])TArray);
        } else {
            MathUtils.checkNotNull(TArray);
            int n = TArray.length;
            if (n == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int n2 = TArray[0].length;
            if (n2 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            for (int i = 1; i < n; ++i) {
                if (TArray[i].length == n2) continue;
                throw new DimensionMismatchException(n2, TArray[i].length);
            }
            this.data = TArray;
        }
    }

    public Array2DRowFieldMatrix(T[] TArray) throws NoDataException {
        this(Array2DRowFieldMatrix.extractField(TArray), (FieldElement[])TArray);
    }

    public Array2DRowFieldMatrix(Field<T> field, T[] TArray) {
        super(field);
        int n = TArray.length;
        this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), n, 1);
        for (int i = 0; i < n; ++i) {
            this.data[i][0] = TArray[i];
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int n, int n2) throws NotStrictlyPositiveException {
        return new Array2DRowFieldMatrix(this.getField(), n, n2);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.getField(), this.copyOut(), false);
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) throws MatrixDimensionMismatchException {
        this.checkAdditionCompatible(array2DRowFieldMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, n2);
        for (int i = 0; i < n; ++i) {
            T[] TArray = this.data[i];
            T[] TArray2 = array2DRowFieldMatrix.data[i];
            FieldElement[] fieldElementArray2 = fieldElementArray[i];
            for (int j = 0; j < n2; ++j) {
                fieldElementArray2[j] = (FieldElement)TArray[j].add(TArray2[j]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), fieldElementArray, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) throws MatrixDimensionMismatchException {
        this.checkSubtractionCompatible(array2DRowFieldMatrix);
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, n2);
        for (int i = 0; i < n; ++i) {
            T[] TArray = this.data[i];
            T[] TArray2 = array2DRowFieldMatrix.data[i];
            FieldElement[] fieldElementArray2 = fieldElementArray[i];
            for (int j = 0; j < n2; ++j) {
                fieldElementArray2[j] = (FieldElement)TArray[j].subtract(TArray2[j]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), fieldElementArray, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) throws DimensionMismatchException {
        this.checkMultiplicationCompatible(array2DRowFieldMatrix);
        int n = this.getRowDimension();
        int n2 = array2DRowFieldMatrix.getColumnDimension();
        int n3 = this.getColumnDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, n2);
        for (int i = 0; i < n; ++i) {
            T[] TArray = this.data[i];
            FieldElement[] fieldElementArray2 = fieldElementArray[i];
            for (int j = 0; j < n2; ++j) {
                FieldElement fieldElement = (FieldElement)this.getField().getZero();
                for (int k = 0; k < n3; ++k) {
                    fieldElement = fieldElement.add((FieldElement)TArray[k].multiply(array2DRowFieldMatrix.data[k][j]));
                }
                fieldElementArray2[j] = fieldElement;
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), fieldElementArray, false);
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] TArray, int n, int n2) throws OutOfRangeException, NullArgumentException, NoDataException, DimensionMismatchException {
        if (this.data == null) {
            if (n > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, n);
            }
            if (n2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, n2);
            }
            int n3 = TArray.length;
            if (n3 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int n4 = TArray[0].length;
            if (n4 == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), TArray.length, n4);
            for (int i = 0; i < this.data.length; ++i) {
                if (TArray[i].length != n4) {
                    throw new DimensionMismatchException(n4, TArray[i].length);
                }
                System.arraycopy(TArray[i], 0, this.data[i + n], n2, n4);
            }
        } else {
            super.setSubMatrix(TArray, n, n2);
        }
    }

    @Override
    public T getEntry(int n, int n2) throws OutOfRangeException {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        return this.data[n][n2];
    }

    @Override
    public void setEntry(int n, int n2, T t) throws OutOfRangeException {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        this.data[n][n2] = t;
    }

    @Override
    public void addToEntry(int n, int n2, T t) throws OutOfRangeException {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        this.data[n][n2] = (FieldElement)this.data[n][n2].add(t);
    }

    @Override
    public void multiplyEntry(int n, int n2, T t) throws OutOfRangeException {
        this.checkRowIndex(n);
        this.checkColumnIndex(n2);
        this.data[n][n2] = (FieldElement)this.data[n][n2].multiply(t);
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public T[] operate(T[] TArray) throws DimensionMismatchException {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (TArray.length != n2) {
            throw new DimensionMismatchException(TArray.length, n2);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), n);
        for (int i = 0; i < n; ++i) {
            T[] TArray2 = this.data[i];
            FieldElement fieldElement = (FieldElement)this.getField().getZero();
            for (int j = 0; j < n2; ++j) {
                fieldElement = fieldElement.add((FieldElement)TArray2[j].multiply(TArray[j]));
            }
            fieldElementArray[i] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public T[] preMultiply(T[] TArray) throws DimensionMismatchException {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        if (TArray.length != n) {
            throw new DimensionMismatchException(TArray.length, n);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.getField(), n2);
        for (int i = 0; i < n2; ++i) {
            FieldElement fieldElement = (FieldElement)this.getField().getZero();
            for (int j = 0; j < n; ++j) {
                fieldElement = fieldElement.add((FieldElement)this.data[j][i].multiply(TArray[j]));
            }
            fieldElementArray[i] = fieldElement;
        }
        return fieldElementArray;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            T[] TArray = this.data[i];
            for (int j = 0; j < n2; ++j) {
                TArray[j] = fieldMatrixChangingVisitor.visit(i, j, TArray[j]);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n; ++i) {
            T[] TArray = this.data[i];
            for (int j = 0; j < n2; ++j) {
                fieldMatrixPreservingVisitor.visit(i, j, TArray[j]);
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            T[] TArray = this.data[i];
            for (int j = n3; j <= n4; ++j) {
                TArray[j] = fieldMatrixChangingVisitor.visit(i, j, TArray[j]);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n; i <= n2; ++i) {
            T[] TArray = this.data[i];
            for (int j = n3; j <= n4; ++j) {
                fieldMatrixPreservingVisitor.visit(i, j, TArray[j]);
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixChangingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                T[] TArray = this.data[j];
                TArray[i] = fieldMatrixChangingVisitor.visit(j, i, TArray[i]);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor) {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        fieldMatrixPreservingVisitor.start(n, n2, 0, n - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                fieldMatrixPreservingVisitor.visit(j, i, this.data[j][i]);
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> fieldMatrixChangingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixChangingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                T[] TArray = this.data[j];
                TArray[i] = fieldMatrixChangingVisitor.visit(j, i, TArray[i]);
            }
        }
        return fieldMatrixChangingVisitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> fieldMatrixPreservingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(n, n2, n3, n4);
        fieldMatrixPreservingVisitor.start(this.getRowDimension(), this.getColumnDimension(), n, n2, n3, n4);
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                fieldMatrixPreservingVisitor.visit(j, i, this.data[j][i]);
            }
        }
        return fieldMatrixPreservingVisitor.end();
    }

    private T[][] copyOut() {
        int n = this.getRowDimension();
        FieldElement[][] fieldElementArray = (FieldElement[][])MathArrays.buildArray(this.getField(), n, this.getColumnDimension());
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.data[i], 0, fieldElementArray[i], 0, this.data[i].length);
        }
        return fieldElementArray;
    }

    private void copyIn(T[][] TArray) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this.setSubMatrix((FieldElement[][])TArray, 0, 0);
    }
}

