/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.DecompositionSolver;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.NonSquareMatrixException;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.linear.SingularMatrixException;
import org.apache.commons.math4.util.FastMath;

public class LUDecomposition {
    private static final double DEFAULT_TOO_SMALL = 1.0E-11;
    private final double[][] lu;
    private final int[] pivot;
    private boolean even;
    private boolean singular;
    private RealMatrix cachedL;
    private RealMatrix cachedU;
    private RealMatrix cachedP;

    public LUDecomposition(RealMatrix realMatrix) {
        this(realMatrix, 1.0E-11);
    }

    public LUDecomposition(RealMatrix realMatrix, double d) {
        int n;
        if (!realMatrix.isSquare()) {
            throw new NonSquareMatrixException(realMatrix.getRowDimension(), realMatrix.getColumnDimension());
        }
        int n2 = realMatrix.getColumnDimension();
        this.lu = realMatrix.getData();
        this.pivot = new int[n2];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (n = 0; n < n2; ++n) {
            this.pivot[n] = n;
        }
        this.even = true;
        this.singular = false;
        for (n = 0; n < n2; ++n) {
            int n3;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                double[] dArray = this.lu[n4];
                double d2 = dArray[n];
                for (int i = 0; i < n4; ++i) {
                    d2 -= dArray[i] * this.lu[i][n];
                }
                dArray[n] = d2;
            }
            n4 = n;
            double d3 = Double.NEGATIVE_INFINITY;
            for (int i = n; i < n2; ++i) {
                double[] dArray = this.lu[i];
                double d4 = dArray[n];
                for (n3 = 0; n3 < n; ++n3) {
                    d4 -= dArray[n3] * this.lu[n3][n];
                }
                dArray[n] = d4;
                if (!(FastMath.abs(d4) > d3)) continue;
                d3 = FastMath.abs(d4);
                n4 = i;
            }
            if (FastMath.abs(this.lu[n4][n]) < d) {
                this.singular = true;
                return;
            }
            if (n4 != n) {
                double d5 = 0.0;
                double[] dArray = this.lu[n4];
                double[] dArray2 = this.lu[n];
                for (n3 = 0; n3 < n2; ++n3) {
                    d5 = dArray[n3];
                    dArray[n3] = dArray2[n3];
                    dArray2[n3] = d5;
                }
                n3 = this.pivot[n4];
                this.pivot[n4] = this.pivot[n];
                this.pivot[n] = n3;
                this.even = !this.even;
            }
            double d6 = this.lu[n][n];
            for (int i = n + 1; i < n2; ++i) {
                double[] dArray = this.lu[i];
                int n5 = n;
                dArray[n5] = dArray[n5] / d6;
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null && !this.singular) {
            int n = this.pivot.length;
            this.cachedL = MatrixUtils.createRealMatrix(n, n);
            for (int i = 0; i < n; ++i) {
                double[] dArray = this.lu[i];
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setEntry(i, j, dArray[j]);
                }
                this.cachedL.setEntry(i, i, 1.0);
            }
        }
        return this.cachedL;
    }

    public RealMatrix getU() {
        if (this.cachedU == null && !this.singular) {
            int n = this.pivot.length;
            this.cachedU = MatrixUtils.createRealMatrix(n, n);
            for (int i = 0; i < n; ++i) {
                double[] dArray = this.lu[i];
                for (int j = i; j < n; ++j) {
                    this.cachedU.setEntry(i, j, dArray[j]);
                }
            }
        }
        return this.cachedU;
    }

    public RealMatrix getP() {
        if (this.cachedP == null && !this.singular) {
            int n = this.pivot.length;
            this.cachedP = MatrixUtils.createRealMatrix(n, n);
            for (int i = 0; i < n; ++i) {
                this.cachedP.setEntry(i, this.pivot[i], 1.0);
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public double getDeterminant() {
        if (this.singular) {
            return 0.0;
        }
        int n = this.pivot.length;
        double d = this.even ? 1.0 : -1.0;
        for (int i = 0; i < n; ++i) {
            d *= this.lu[i][i];
        }
        return d;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.lu, this.pivot, this.singular);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(double[][] dArray, int[] nArray, boolean bl) {
            this.lu = dArray;
            this.pivot = nArray;
            this.singular = bl;
        }

        @Override
        public boolean isNonSingular() {
            return !this.singular;
        }

        @Override
        public RealVector solve(RealVector realVector) {
            int n;
            double d;
            int n2;
            int n3 = this.pivot.length;
            if (realVector.getDimension() != n3) {
                throw new DimensionMismatchException(realVector.getDimension(), n3);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            double[] dArray = new double[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = realVector.getEntry(this.pivot[n2]);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                d = dArray[n2];
                for (n = n2 + 1; n < n3; ++n) {
                    int n4 = n;
                    dArray[n4] = dArray[n4] - d * this.lu[n][n2];
                }
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                int n5 = n2;
                dArray[n5] = dArray[n5] / this.lu[n2][n2];
                d = dArray[n2];
                for (n = 0; n < n2; ++n) {
                    int n6 = n;
                    dArray[n6] = dArray[n6] - d * this.lu[n][n2];
                }
            }
            return new ArrayRealVector(dArray, false);
        }

        @Override
        public RealMatrix solve(RealMatrix realMatrix) {
            int n;
            double[] dArray;
            int n2;
            int n3 = this.pivot.length;
            if (realMatrix.getRowDimension() != n3) {
                throw new DimensionMismatchException(realMatrix.getRowDimension(), n3);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int n4 = realMatrix.getColumnDimension();
            double[][] dArray2 = new double[n3][n4];
            for (n2 = 0; n2 < n3; ++n2) {
                dArray = dArray2[n2];
                n = this.pivot[n2];
                for (int i = 0; i < n4; ++i) {
                    dArray[i] = realMatrix.getEntry(n, i);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                dArray = dArray2[n2];
                for (n = n2 + 1; n < n3; ++n) {
                    double[] dArray3 = dArray2[n];
                    double d = this.lu[n][n2];
                    for (int i = 0; i < n4; ++i) {
                        int n5 = i;
                        dArray3[n5] = dArray3[n5] - dArray[i] * d;
                    }
                }
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                dArray = dArray2[n2];
                double d = this.lu[n2][n2];
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = n6++;
                    dArray[n7] = dArray[n7] / d;
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    double[] dArray4 = dArray2[n6];
                    double d2 = this.lu[n6][n2];
                    for (int i = 0; i < n4; ++i) {
                        int n8 = i;
                        dArray4[n8] = dArray4[n8] - dArray[i] * d2;
                    }
                }
            }
            return new Array2DRowRealMatrix(dArray2, false);
        }

        @Override
        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.pivot.length));
        }
    }
}

