/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.Factorial;
import org.apache.commons.numbers.core.ArithmeticUtils;

public final class CombinatoricsUtils {
    static final AtomicReference<long[][]> STIRLING_S2 = new AtomicReference<Object>(null);

    private CombinatoricsUtils() {
    }

    public static long stirlingS2(int n, int n2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        if (n2 < 0) {
            throw new NotPositiveException(n2);
        }
        if (n2 > n) {
            throw new NumberIsTooLargeException(n2, (Number)n, true);
        }
        Object object = STIRLING_S2.get();
        if (object == null) {
            object = new long[26][];
            object[0] = new long[]{1L};
            for (int i = 1; i < ((long[][])object).length; ++i) {
                object[i] = new long[i + 1];
                object[i][0] = 0L;
                object[i][1] = 1L;
                object[i][i] = 1L;
                for (int j = 2; j < i; ++j) {
                    object[i][j] = (long)j * object[i - 1][j] + object[i - 1][j - 1];
                }
            }
            STIRLING_S2.compareAndSet((long[][])null, (long[][])object);
        }
        if (n < ((long[][])object).length) {
            return object[n][n2];
        }
        if (n2 == 0) {
            return 0L;
        }
        if (n2 == 1 || n2 == n) {
            return 1L;
        }
        if (n2 == 2) {
            return (1L << n - 1) - 1L;
        }
        if (n2 == n - 1) {
            return BinomialCoefficient.value(n, 2);
        }
        long l = 0L;
        long l2 = (n2 & 1) == 0 ? 1L : -1L;
        for (int i = 1; i <= n2; ++i) {
            if ((l += (l2 = -l2) * BinomialCoefficient.value(n2, i) * (long)ArithmeticUtils.pow(i, n)) >= 0L) continue;
            throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n, 0, ((long[][])object).length - 1);
        }
        return l / Factorial.value(n2);
    }
}

