/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

public class LinearCombination {
    public static double value(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Dimension mismatch: " + dArray.length + " != " + dArray2.length);
        }
        int n = dArray.length;
        if (n == 1) {
            return dArray[0] * dArray2[0];
        }
        double[] dArray3 = new double[n];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i];
            double d3 = LinearCombination.highPart(d2);
            double d4 = d2 - d3;
            double d5 = dArray2[i];
            double d6 = LinearCombination.highPart(d5);
            double d7 = d5 - d6;
            dArray3[i] = d2 * d5;
            double d8 = LinearCombination.prodLow(d4, d7, dArray3[i], d3, d6);
            d += d8;
        }
        double d9 = dArray3[0];
        double d10 = dArray3[1];
        double d11 = d9 + d10;
        double d12 = d11 - d10;
        double d13 = d10 - (d11 - d12) + (d9 - d12);
        int n2 = n - 1;
        for (int i = 1; i < n2; ++i) {
            d10 = dArray3[i + 1];
            double d14 = d11 + d10;
            d12 = d14 - d10;
            d13 += d10 - (d14 - d12) + (d11 - d12);
            d11 = d14;
        }
        double d15 = d11 + (d + d13);
        if (Double.isNaN(d15)) {
            d15 = 0.0;
            for (int i = 0; i < n; ++i) {
                d15 += dArray[i] * dArray2[i];
            }
        }
        return d15;
    }

    public static double value(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = d * d2;
        double d15 = d3 * d4;
        double d16 = d14 + d15;
        double d17 = LinearCombination.highPart(d);
        double d18 = d - d17;
        double d19 = LinearCombination.prodLow(d18, d13 = d2 - (d12 = LinearCombination.highPart(d2)), d14, d17, d12);
        double d20 = d16 + (d19 + (d11 = LinearCombination.prodLow(d10 = d3 - (d9 = LinearCombination.highPart(d3)), d8 = d4 - (d7 = LinearCombination.highPart(d4)), d15, d9, d7)) + (d6 = d15 - (d16 - (d5 = d16 - d15)) + (d14 - d5)));
        if (Double.isNaN(d20)) {
            d20 = d * d2 + d3 * d4;
        }
        return d20;
    }

    public static double value(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23 = d * d2;
        double d24 = d3 * d4;
        double d25 = d23 + d24;
        double d26 = d5 * d6;
        double d27 = d25 + d26;
        double d28 = LinearCombination.highPart(d);
        double d29 = d - d28;
        double d30 = LinearCombination.prodLow(d29, d22 = d2 - (d21 = LinearCombination.highPart(d2)), d23, d28, d21);
        double d31 = d27 + (d30 + (d20 = LinearCombination.prodLow(d19 = d3 - (d18 = LinearCombination.highPart(d3)), d17 = d4 - (d16 = LinearCombination.highPart(d4)), d24, d18, d16)) + (d15 = LinearCombination.prodLow(d14 = d5 - (d13 = LinearCombination.highPart(d5)), d12 = d6 - (d11 = LinearCombination.highPart(d6)), d26, d13, d11)) + (d10 = d24 - (d25 - (d9 = d25 - d24)) + (d23 - d9)) + (d8 = d26 - (d27 - (d7 = d27 - d26)) + (d25 - d7)));
        if (Double.isNaN(d31)) {
            d31 = d * d2 + d3 * d4 + d5 * d6;
        }
        return d31;
    }

    public static double value(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23;
        double d24;
        double d25;
        double d26;
        double d27;
        double d28;
        double d29;
        double d30;
        double d31;
        double d32 = d * d2;
        double d33 = d3 * d4;
        double d34 = d32 + d33;
        double d35 = d5 * d6;
        double d36 = d34 + d35;
        double d37 = d7 * d8;
        double d38 = d36 + d37;
        double d39 = LinearCombination.highPart(d);
        double d40 = d - d39;
        double d41 = LinearCombination.prodLow(d40, d31 = d2 - (d30 = LinearCombination.highPart(d2)), d32, d39, d30);
        double d42 = d38 + (d41 + (d29 = LinearCombination.prodLow(d28 = d3 - (d27 = LinearCombination.highPart(d3)), d26 = d4 - (d25 = LinearCombination.highPart(d4)), d33, d27, d25)) + (d24 = LinearCombination.prodLow(d23 = d5 - (d22 = LinearCombination.highPart(d5)), d21 = d6 - (d20 = LinearCombination.highPart(d6)), d35, d22, d20)) + (d19 = LinearCombination.prodLow(d18 = d7 - (d17 = LinearCombination.highPart(d7)), d16 = d8 - (d15 = LinearCombination.highPart(d8)), d37, d17, d15)) + (d14 = d33 - (d34 - (d13 = d34 - d33)) + (d32 - d13)) + (d12 = d35 - (d36 - (d11 = d36 - d35)) + (d34 - d11)) + (d10 = d37 - (d38 - (d9 = d38 - d37)) + (d36 - d9)));
        if (Double.isNaN(d42)) {
            d42 = d * d2 + d3 * d4 + d5 * d6 + d7 * d8;
        }
        return d42;
    }

    private static double highPart(double d) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
    }

    private static double prodLow(double d, double d2, double d3, double d4, double d5) {
        return d * d2 - (d3 - d4 * d5 - d * d5 - d4 * d2);
    }
}

