/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;

public class LogBinomialCoefficient {
    public static double value(int n, int n2) {
        int n3;
        BinomialCoefficient.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 0.0;
        }
        if (n2 == 1 || n2 == n - 1) {
            return Math.log(n);
        }
        if (n < 67) {
            return Math.log(BinomialCoefficient.value(n, n2));
        }
        if (n < 1030) {
            return Math.log(BinomialCoefficientDouble.value(n, n2));
        }
        if (n2 > n / 2) {
            return LogBinomialCoefficient.value(n, n - n2);
        }
        double d = 0.0;
        for (n3 = n - n2 + 1; n3 <= n; ++n3) {
            d += Math.log(n3);
        }
        for (n3 = 2; n3 <= n2; ++n3) {
            d -= Math.log(n3);
        }
        return d;
    }
}

