/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.fraction;

import org.apache.commons.numbers.core.Precision;
import org.apache.commons.numbers.fraction.FractionException;

public abstract class ContinuedFraction {
    private static final double DEFAULT_EPSILON = 1.0E-9;

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double d) {
        return this.evaluate(d, 1.0E-9, Integer.MAX_VALUE);
    }

    public double evaluate(double d, double d2) {
        return this.evaluate(d, d2, Integer.MAX_VALUE);
    }

    public double evaluate(double d, int n) {
        return this.evaluate(d, 1.0E-9, n);
    }

    public double evaluate(double d, double d2, int n) {
        double d3 = this.getA(0, d);
        if (Precision.equals(d3, 0.0, 1.0E-50)) {
            d3 = 1.0E-50;
        }
        double d4 = 0.0;
        double d5 = d3;
        double d6 = d3;
        for (int i = 1; i <= n; ++i) {
            double d7;
            double d8;
            double d9;
            double d10 = this.getA(i, d);
            double d11 = d10 + (d9 = this.getB(i, d)) * d4;
            if (Precision.equals(d11, 0.0, 1.0E-50)) {
                d11 = 1.0E-50;
            }
            if (Precision.equals(d8 = d10 + d9 / d5, 0.0, 1.0E-50)) {
                d8 = 1.0E-50;
            }
            if (Double.isInfinite(d6 = d3 * (d7 = d8 * (d11 = 1.0 / d11)))) {
                throw new FractionException("Continued fraction convergents diverged to +/- infinity for value {0}", d);
            }
            if (Double.isNaN(d6)) {
                throw new FractionException("Continued fraction diverged to NaN for value {0}", d);
            }
            if (Math.abs(d7 - 1.0) < d2) {
                return d6;
            }
            d4 = d11;
            d5 = d8;
            d3 = d6;
        }
        throw new FractionException("maximal count ({0}) exceeded", n);
    }
}

