/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.rng.UniformRandomProvider;

public class DiscreteProbabilityCollectionSampler<T> {
    private final List<T> items;
    private final UniformRandomProvider rng;
    private final double[] cumulativeProbabilities;

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider uniformRandomProvider, Map<T, Double> map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Empty collection");
        }
        this.rng = uniformRandomProvider;
        int n = map.size();
        this.items = new ArrayList<T>(n);
        this.cumulativeProbabilities = new double[n];
        double d = 0.0;
        int n2 = 0;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            this.items.add(entry.getKey());
            double d2 = entry.getValue();
            if (d2 < 0.0 || Double.isInfinite(d2) || Double.isNaN(d2)) {
                throw new IllegalArgumentException("Invalid probability: " + d2);
            }
            this.cumulativeProbabilities[n2++] = d2;
            d += d2;
        }
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("Invalid sum of probabilities");
        }
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            this.cumulativeProbabilities[n3] = this.cumulativeProbabilities[n3] / d;
            if (i <= 0) continue;
            int n4 = i;
            this.cumulativeProbabilities[n4] = this.cumulativeProbabilities[n4] + this.cumulativeProbabilities[i - 1];
        }
    }

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider uniformRandomProvider, List<T> list, double[] dArray) {
        this(uniformRandomProvider, DiscreteProbabilityCollectionSampler.consolidate(list, dArray));
    }

    public T sample() {
        double d = this.rng.nextDouble();
        int n = Arrays.binarySearch(this.cumulativeProbabilities, d);
        if (n < 0) {
            n = -n - 1;
        }
        if (n < this.cumulativeProbabilities.length && d < this.cumulativeProbabilities[n]) {
            return this.items.get(n);
        }
        return this.items.get(this.items.size() - 1);
    }

    private static <T> Map<T, Double> consolidate(List<T> list, double[] dArray) {
        int n = dArray.length;
        if (n != list.size()) {
            throw new IllegalArgumentException("Size mismatch: " + n + " != " + list.size());
        }
        HashMap<T, Double> hashMap = new HashMap<T, Double>();
        for (int i = 0; i < n; ++i) {
            T t = list.get(i);
            Double d = dArray[i];
            Double d2 = (Double)hashMap.get(t);
            if (d2 == null) {
                d2 = 0.0;
            }
            hashMap.put(t, d2 + d);
        }
        return hashMap;
    }
}

