/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleToIntFunction;
import java.util.function.LongToIntFunction;

public class DiscreteLongIntSampler
implements LongToIntFunction {
    private final DoubleToIntFunction f;
    private ThreadSafeHash hash;

    public DiscreteLongIntSampler(DoubleToIntFunction doubleToIntFunction, boolean bl) {
        this.f = doubleToIntFunction;
        if (bl) {
            this.hash = new ThreadSafeHash();
        }
    }

    @Override
    public int applyAsInt(long l) {
        if (this.hash != null) {
            l = this.hash.applyAsLong(l);
        }
        double d = (double)l / 9.223372036854776E18;
        int n = this.f.applyAsInt(d);
        return n;
    }
}

