/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.rank;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class Min
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private long n;
    private double value;

    public Min() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Min(Min min) throws NullArgumentException {
        Min.copy(min, this);
    }

    @Override
    public void increment(double d) {
        if (d < this.value || Double.isNaN(this.value)) {
            this.value = d;
        }
        ++this.n;
    }

    @Override
    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2)) {
            d = dArray[n];
            for (int i = n; i < n + n2; ++i) {
                if (Double.isNaN(dArray[i])) continue;
                d = d < dArray[i] ? d : dArray[i];
            }
        }
        return d;
    }

    @Override
    public Min copy() {
        Min min = new Min();
        Min.copy(this, min);
        return min;
    }

    public static void copy(Min min, Min min2) throws NullArgumentException {
        MathUtils.checkNotNull(min);
        MathUtils.checkNotNull(min2);
        min2.n = min.n;
        min2.value = min.value;
    }
}

