/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.interval;

import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.interval.BinomialConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.ConfidenceInterval;
import io.virtdata.shaded.oac.statistics.interval.IntervalUtils;
import org.apache.commons.math4.util.FastMath;

public class NormalApproximationInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int n, int n2, double d) {
        IntervalUtils.checkParameters(n, n2, d);
        double d2 = (double)n2 / (double)n;
        double d3 = (1.0 - d) / 2.0;
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        double d4 = normalDistribution.inverseCumulativeProbability(1.0 - d3) * FastMath.sqrt(1.0 / (double)n * d2 * (1.0 - d2));
        return new ConfidenceInterval(d2 - d4, d2 + d4, d);
    }
}

