/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration.gauss;

import java.util.Arrays;
import org.apache.commons.math4.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.analysis.polynomials.PolynomialsUtils;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.linear.EigenDecomposition;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.util.Pair;

public class LaguerreRuleFactory
extends BaseRuleFactory<Double> {
    @Override
    protected Pair<Double[], Double[]> computeRule(int n) throws DimensionMismatchException {
        RealMatrix realMatrix = this.companionMatrix(n);
        EigenDecomposition eigenDecomposition = new EigenDecomposition(realMatrix);
        double[] dArray = eigenDecomposition.getRealEigenvalues();
        Arrays.sort(dArray);
        Double[] doubleArray = new Double[n];
        Double[] doubleArray2 = new Double[n];
        int n2 = n + 1;
        long l = (long)n2 * (long)n2;
        PolynomialFunction polynomialFunction = PolynomialsUtils.createLaguerrePolynomial(n2);
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            doubleArray[i] = d;
            double d2 = polynomialFunction.value(d);
            doubleArray2[i] = d / (double)l / (d2 * d2);
        }
        return new Pair<Double[], Double[]>(doubleArray, doubleArray2);
    }

    private RealMatrix companionMatrix(int n) {
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            realMatrix.setEntry(i, i, 2 * i + 1);
            if (i + 1 < n) {
                realMatrix.setEntry(i + 1, i, -(i + 1));
            }
            if (i - 1 < 0) continue;
            realMatrix.setEntry(i - 1, i, -i);
        }
        return realMatrix;
    }
}

