/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import org.apache.commons.math4.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.numbers.core.Precision;

public class AkimaSplineInterpolator
implements UnivariateInterpolator {
    private static final int MINIMUM_NUMBER_POINTS = 5;

    @Override
    public PolynomialSplineFunction interpolate(double[] dArray, double[] dArray2) throws DimensionMismatchException, NumberIsTooSmallException, NonMonotonicSequenceException {
        int n;
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length < 5) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 5, true);
        }
        MathArrays.checkOrder(dArray);
        int n2 = dArray.length - 1;
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        for (n = 0; n < dArray3.length; ++n) {
            dArray3[n] = (dArray2[n + 1] - dArray2[n]) / (dArray[n + 1] - dArray[n]);
        }
        for (n = 1; n < dArray4.length; ++n) {
            dArray4[n] = FastMath.abs(dArray3[n] - dArray3[n - 1]);
        }
        double[] dArray5 = new double[dArray.length];
        for (int i = 2; i < dArray5.length - 2; ++i) {
            double d = dArray4[i + 1];
            double d2 = dArray4[i - 1];
            if (Precision.equals(d, 0.0) && Precision.equals(d2, 0.0)) {
                double d3 = dArray[i];
                double d4 = dArray[i + 1];
                double d5 = dArray[i - 1];
                dArray5[i] = ((d4 - d3) * dArray3[i - 1] + (d3 - d5) * dArray3[i]) / (d4 - d5);
                continue;
            }
            dArray5[i] = (d * dArray3[i - 1] + d2 * dArray3[i]) / (d + d2);
        }
        dArray5[0] = this.differentiateThreePoint(dArray, dArray2, 0, 0, 1, 2);
        dArray5[1] = this.differentiateThreePoint(dArray, dArray2, 1, 0, 1, 2);
        dArray5[dArray.length - 2] = this.differentiateThreePoint(dArray, dArray2, dArray.length - 2, dArray.length - 3, dArray.length - 2, dArray.length - 1);
        dArray5[dArray.length - 1] = this.differentiateThreePoint(dArray, dArray2, dArray.length - 1, dArray.length - 3, dArray.length - 2, dArray.length - 1);
        return this.interpolateHermiteSorted(dArray, dArray2, dArray5);
    }

    private double differentiateThreePoint(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        double d = dArray2[n2];
        double d2 = dArray2[n3];
        double d3 = dArray2[n4];
        double d4 = dArray[n] - dArray[n2];
        double d5 = dArray[n3] - dArray[n2];
        double d6 = dArray[n4] - dArray[n2];
        double d7 = (d3 - d - d6 / d5 * (d2 - d)) / (d6 * d6 - d5 * d6);
        double d8 = (d2 - d - d7 * d5 * d5) / d5;
        return 2.0 * d7 * d4 + d8;
    }

    private PolynomialSplineFunction interpolateHermiteSorted(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray.length != dArray3.length) {
            throw new DimensionMismatchException(dArray.length, dArray3.length);
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, (Number)dArray.length, 2, true);
        }
        int n = dArray.length - 1;
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[n];
        double[] dArray4 = new double[4];
        for (int i = 0; i < polynomialFunctionArray.length; ++i) {
            double d = dArray[i + 1] - dArray[i];
            double d2 = d * d;
            double d3 = dArray2[i];
            double d4 = dArray2[i + 1];
            double d5 = dArray3[i];
            double d6 = dArray3[i + 1];
            dArray4[0] = d3;
            dArray4[1] = dArray3[i];
            dArray4[2] = (3.0 * (d4 - d3) / d - 2.0 * d5 - d6) / d;
            dArray4[3] = (2.0 * (d3 - d4) / d + d5 + d6) / d2;
            polynomialFunctionArray[i] = new PolynomialFunction(dArray4);
        }
        return new PolynomialSplineFunction(dArray, polynomialFunctionArray);
    }
}

