/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.polynomials;

import java.util.Arrays;
import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;

public class PolynomialSplineFunction
implements UnivariateDifferentiableFunction {
    private final double[] knots;
    private final PolynomialFunction[] polynomials;
    private final int n;

    public PolynomialSplineFunction(double[] dArray, PolynomialFunction[] polynomialFunctionArray) throws NullArgumentException, NumberIsTooSmallException, DimensionMismatchException, NonMonotonicSequenceException {
        if (dArray == null || polynomialFunctionArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NOT_ENOUGH_POINTS_IN_SPLINE_PARTITION, (Number)dArray.length, 2, true);
        }
        if (dArray.length - 1 != polynomialFunctionArray.length) {
            throw new DimensionMismatchException(polynomialFunctionArray.length, dArray.length);
        }
        MathArrays.checkOrder(dArray);
        this.n = dArray.length - 1;
        this.knots = new double[this.n + 1];
        System.arraycopy(dArray, 0, this.knots, 0, this.n + 1);
        this.polynomials = new PolynomialFunction[this.n];
        System.arraycopy(polynomialFunctionArray, 0, this.polynomials, 0, this.n);
    }

    @Override
    public double value(double d) {
        if (d < this.knots[0] || d > this.knots[this.n]) {
            throw new OutOfRangeException(d, (Number)this.knots[0], this.knots[this.n]);
        }
        int n = Arrays.binarySearch(this.knots, d);
        if (n < 0) {
            n = -n - 2;
        }
        if (n >= this.polynomials.length) {
            --n;
        }
        return this.polynomials[n].value(d - this.knots[n]);
    }

    public PolynomialSplineFunction polynomialSplineDerivative() {
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[this.n];
        for (int i = 0; i < this.n; ++i) {
            polynomialFunctionArray[i] = this.polynomials[i].polynomialDerivative();
        }
        return new PolynomialSplineFunction(this.knots, polynomialFunctionArray);
    }

    @Override
    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double d = derivativeStructure.getValue();
        if (d < this.knots[0] || d > this.knots[this.n]) {
            throw new OutOfRangeException(d, (Number)this.knots[0], this.knots[this.n]);
        }
        int n = Arrays.binarySearch(this.knots, d);
        if (n < 0) {
            n = -n - 2;
        }
        if (n >= this.polynomials.length) {
            --n;
        }
        return this.polynomials[n].value(derivativeStructure.subtract(this.knots[n]));
    }

    public int getN() {
        return this.n;
    }

    public PolynomialFunction[] getPolynomials() {
        PolynomialFunction[] polynomialFunctionArray = new PolynomialFunction[this.n];
        System.arraycopy(this.polynomials, 0, polynomialFunctionArray, 0, this.n);
        return polynomialFunctionArray;
    }

    public double[] getKnots() {
        double[] dArray = new double[this.n + 1];
        System.arraycopy(this.knots, 0, dArray, 0, this.n + 1);
        return dArray;
    }

    public boolean isValidPoint(double d) {
        return !(d < this.knots[0]) && !(d > this.knots[this.n]);
    }
}

